package com.chenyang.druid.sql.dialect.greenplum.ast.expr;

import com.chenyang.druid.sql.SQLUtils;
import com.chenyang.druid.sql.ast.expr.SQLCastExpr;
import com.chenyang.druid.sql.dialect.greenplum.visitor.GPASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;

public class GPTypeCastExpr extends SQLCastExpr implements GPExpr {
   public void accept0(GPASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.expr);
         this.acceptChild(visitor, this.dataType);
      }

      visitor.endVisit(this);
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor instanceof GPASTVisitor) {
         this.accept0((GPASTVisitor)visitor);
      } else {
         super.accept0(visitor);
      }
   }

   public String toString() {
      return SQLUtils.toPGString(this);
   }
}
