package com.chenyang.druid.sql.dialect.greenplum.ast.expr.tablesource;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLHint;
import com.chenyang.druid.sql.ast.SQLParameter;
import com.chenyang.druid.sql.ast.statement.SQLExprTableSource;
import com.chenyang.druid.sql.dialect.greenplum.ast.GPSQLObject;
import com.chenyang.druid.sql.dialect.greenplum.visitor.GPASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class GPFunctionTableSource extends SQLExprTableSource implements GPSQLObject {
   private final List<SQLParameter> parameters = new ArrayList();

   public GPFunctionTableSource() {
   }

   public GPFunctionTableSource(SQLExpr expr) {
      this.expr = expr;
   }

   public List<SQLParameter> getParameters() {
      return this.parameters;
   }

   protected void accept0(SQLASTVisitor visitor) {
      this.accept0((GPASTVisitor)visitor);
   }

   public void accept0(GPASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.expr);
         this.acceptChild(visitor, this.parameters);
      }

      visitor.endVisit(this);
   }

   public GPFunctionTableSource clone() {
      GPFunctionTableSource x = new GPFunctionTableSource();
      x.setAlias(this.alias);

      for(SQLParameter e : this.parameters) {
         SQLParameter e2 = e.clone();
         e2.setParent(x);
         x.getParameters().add(e2);
      }

      if (this.flashback != null) {
         x.setFlashback(this.flashback.clone());
      }

      if (this.hints != null) {
         for(SQLHint e : this.hints) {
            SQLHint e2 = e.clone();
            e2.setParent(x);
            x.getHints().add(e2);
         }
      }

      return x;
   }
}
