package com.chenyang.druid.sql.dialect.greenplum.ast.expr.tablesource;

import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.chenyang.druid.sql.dialect.greenplum.ast.GPSQLObject;
import com.chenyang.druid.sql.dialect.greenplum.visitor.GPASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;

public class GPSubqueryTableSource extends SQLSubqueryTableSource implements GPSQLObject, GPTableSource {
   protected boolean only;

   public GPSubqueryTableSource clone() {
      GPSubqueryTableSource x = new GPSubqueryTableSource();
      this.cloneTo(x);
      x.only = this.only;
      return x;
   }

   public void accept0(GPASTVisitor visitor) {
      if (visitor.visit(this) && this.select != null) {
         this.select.accept(visitor);
      }

      visitor.endVisit(this);
   }

   public void addColumnAlias(SQLName name) {
      if (this.columns == null) {
         this.columns = new ArrayList();
      }

      this.columns.add(name);
   }

   protected void accept0(SQLASTVisitor visitor) {
      this.accept0((GPASTVisitor)visitor);
   }

   public boolean isOnly() {
      return this.only;
   }

   public void setOnly(boolean only) {
      this.only = only;
   }
}
