package com.chenyang.druid.sql.dialect.greenplum.ast.stmt;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.ast.statement.SQLAlterStatement;
import com.chenyang.druid.sql.ast.statement.SQLAlterTableStatement;
import com.chenyang.druid.sql.dialect.greenplum.visitor.GPASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;

public class GPAlterTableStatement extends SQLAlterTableStatement implements GPSQLStatement, SQLAlterStatement {
   private boolean only = false;
   private boolean allInTableSpace = false;

   public boolean isAllInTableSpace() {
      return this.allInTableSpace;
   }

   public void setAllInTableSpace(boolean allInTableSpace) {
      this.allInTableSpace = allInTableSpace;
   }

   public boolean isOnly() {
      return this.only;
   }

   public void setOnly(boolean only) {
      this.only = only;
   }

   public GPAlterTableStatement() {
      this.dbType = DbType.greenplum;
   }

   public void accept0(SQLASTVisitor visitor) {
      this.accept0((GPASTVisitor)visitor);
   }

   public void accept0(GPASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.getTableSource());
         this.acceptChild(visitor, this.getItems());
      }

      visitor.endVisit(this);
   }
}
