package com.chenyang.druid.sql.dialect.greenplum.ast.stmt;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.SQLStatementImpl;
import com.chenyang.druid.sql.dialect.greenplum.visitor.GPASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;

public class GPConnectToStatement extends SQLStatementImpl implements GPSQLStatement {
   private SQLName target;

   public GPConnectToStatement() {
      super(DbType.greenplum);
   }

   protected void accept0(SQLASTVisitor visitor) {
      this.accept0((GPASTVisitor)visitor);
   }

   public void accept0(GPASTVisitor v) {
      if (v.visit(this)) {
         this.acceptChild(v, this.target);
      }

      v.endVisit(this);
   }

   public SQLName getTarget() {
      return this.target;
   }

   public void setTarget(SQLName x) {
      if (x != null) {
         x.setParent(this);
      }

      this.target = x;
   }
}
