package com.chenyang.druid.sql.dialect.greenplum.ast.stmt;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.ast.SQLCommentHint;
import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.statement.SQLInsertStatement;
import com.chenyang.druid.sql.ast.statement.SQLUpdateSetItem;
import com.chenyang.druid.sql.dialect.greenplum.visitor.GPASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class GPInsertStatement extends SQLInsertStatement implements GPSQLStatement {
   private List<ValuesClause> valuesList = new ArrayList();
   private SQLExpr returning;
   private boolean defaultValues = false;
   private List<SQLExpr> onConflictTarget;
   private SQLName onConflictConstraint;
   private SQLExpr onConflictWhere;
   private SQLExpr onConflictUpdateWhere;
   private boolean onConflictDoNothing;
   private List<SQLUpdateSetItem> onConflictUpdateSetItems;

   public GPInsertStatement() {
      this.dbType = DbType.greenplum;
   }

   public void cloneTo(GPInsertStatement x) {
      super.cloneTo(x);

      for(ValuesClause v : this.valuesList) {
         ValuesClause v2 = v.clone();
         v2.setParent(x);
         x.valuesList.add(v2);
      }

      if (this.returning != null) {
         x.setReturning(this.returning.clone());
      }

      x.defaultValues = this.defaultValues;
   }

   public SQLExpr getReturning() {
      return this.returning;
   }

   public void setReturning(SQLExpr returning) {
      this.returning = returning;
   }

   public ValuesClause getValues() {
      return this.valuesList.size() == 0 ? null : (ValuesClause)this.valuesList.get(0);
   }

   public void setValues(ValuesClause values) {
      if (this.valuesList.size() == 0) {
         this.valuesList.add(values);
      } else {
         this.valuesList.set(0, values);
      }

   }

   public List<ValuesClause> getValuesList() {
      return this.valuesList;
   }

   public void addValueCause(ValuesClause valueClause) {
      valueClause.setParent(this);
      this.valuesList.add(valueClause);
   }

   public boolean isDefaultValues() {
      return this.defaultValues;
   }

   public void setDefaultValues(boolean defaultValues) {
      this.defaultValues = defaultValues;
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor instanceof GPASTVisitor) {
         this.accept0((GPASTVisitor)visitor);
      } else {
         super.accept0(visitor);
      }

   }

   public void accept0(GPASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.with);
         this.acceptChild(visitor, this.tableSource);
         this.acceptChild(visitor, this.columns);
         this.acceptChild(visitor, this.valuesList);
         this.acceptChild(visitor, this.query);
         this.acceptChild(visitor, this.returning);
      }

      visitor.endVisit(this);
   }

   public GPInsertStatement clone() {
      GPInsertStatement x = new GPInsertStatement();
      this.cloneTo(x);
      return x;
   }

   public List<SQLExpr> getOnConflictTarget() {
      return this.onConflictTarget;
   }

   public void setOnConflictTarget(List<SQLExpr> onConflictTarget) {
      this.onConflictTarget = onConflictTarget;
   }

   public boolean isOnConflictDoNothing() {
      return this.onConflictDoNothing;
   }

   public void setOnConflictDoNothing(boolean onConflictDoNothing) {
      this.onConflictDoNothing = onConflictDoNothing;
   }

   public List<SQLUpdateSetItem> getOnConflictUpdateSetItems() {
      return this.onConflictUpdateSetItems;
   }

   public void addConflicUpdateItem(SQLUpdateSetItem item) {
      if (this.onConflictUpdateSetItems == null) {
         this.onConflictUpdateSetItems = new ArrayList();
      }

      item.setParent(this);
      this.onConflictUpdateSetItems.add(item);
   }

   public SQLName getOnConflictConstraint() {
      return this.onConflictConstraint;
   }

   public void setOnConflictConstraint(SQLName x) {
      if (x != null) {
         x.setParent(this);
      }

      this.onConflictConstraint = x;
   }

   public SQLExpr getOnConflictWhere() {
      return this.onConflictWhere;
   }

   public void setOnConflictWhere(SQLExpr x) {
      if (x != null) {
         x.setParent(this);
      }

      this.onConflictWhere = x;
   }

   public SQLExpr getOnConflictUpdateWhere() {
      return this.onConflictUpdateWhere;
   }

   public void setOnConflictUpdateWhere(SQLExpr x) {
      if (x != null) {
         x.setParent(this);
      }

      this.onConflictUpdateWhere = x;
   }

   public List<SQLCommentHint> getHeadHintsDirect() {
      return null;
   }
}
