package com.chenyang.druid.sql.dialect.greenplum.ast.stmt.alterTable;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.statement.SQLAlterTableItem;
import com.chenyang.druid.sql.dialect.greenplum.ast.GPSQLObject;
import com.chenyang.druid.sql.dialect.greenplum.ast.GPSQLObjectImpl;
import com.chenyang.druid.sql.dialect.greenplum.visitor.GPASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;

public class GPAlterTableDisableEnabelTrigger extends GPSQLObjectImpl implements SQLAlterTableItem, GPSQLObject {
   private boolean isEnable;
   private SQLExpr trigger;
   private Type type = null;

   public SQLExpr getTrigger() {
      return this.trigger;
   }

   public void setTrigger(SQLExpr trigger) {
      this.trigger = trigger;
      trigger.setParent(this);
   }

   public Type getType() {
      return this.type;
   }

   public void setType(Type type) {
      this.type = type;
   }

   public boolean isEnable() {
      return this.isEnable;
   }

   public void setEnable(boolean enable) {
      this.isEnable = enable;
   }

   public void accept0(SQLASTVisitor visitor) {
      this.accept0((GPASTVisitor)visitor);
   }

   public void accept0(GPASTVisitor visitor) {
      if (visitor.visit(this) && this.trigger != null) {
         this.trigger.accept(visitor);
      }

      visitor.endVisit(this);
   }

   public GPAlterTableDisableEnabelTrigger clone() {
      GPAlterTableDisableEnabelTrigger c = new GPAlterTableDisableEnabelTrigger();
      c.setTrigger(this.trigger.clone());
      c.type = this.type;
      c.isEnable = this.isEnable;
      return c;
   }

   public static enum Type {
      all,
      user;
   }
}
