package com.chenyang.druid.sql.dialect.greenplum.ast.stmt.alterTable;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.statement.SQLAlterTableItem;
import com.chenyang.druid.sql.dialect.greenplum.ast.GPSQLObjectImpl;
import com.chenyang.druid.sql.dialect.greenplum.visitor.GPASTVisitor;

public class GPAlterTableSetSchema extends GPSQLObjectImpl implements SQLAlterTableItem {
   private SQLExpr schema;

   public void accept0(GPASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.schema);
      }

      visitor.endVisit(this);
   }

   public SQLExpr getSchema() {
      return this.schema;
   }

   public void setSchema(SQLExpr schema) {
      schema.setParent(this);
      this.schema = schema;
   }

   public GPAlterTableSetSchema clone() {
      GPAlterTableSetSchema c = new GPAlterTableSetSchema();
      c.setSchema(this.schema.clone());
      return c;
   }
}
