package com.chenyang.druid.sql.dialect.hive.ast;

import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.statement.SQLAssignItem;
import com.chenyang.druid.sql.ast.statement.SQLExprTableSource;
import com.chenyang.druid.sql.ast.statement.SQLInsertInto;
import com.chenyang.druid.sql.ast.statement.SQLInsertStatement;
import com.chenyang.druid.sql.ast.statement.SQLSelect;
import com.chenyang.druid.sql.dialect.hive.visitor.HiveASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class HiveInsert extends SQLInsertInto {
   public HiveInsert() {
      this.partitions = new ArrayList();
   }

   public void setPartitions(List<SQLAssignItem> partitions) {
      this.partitions = partitions;
   }

   public SQLInsertInto clone() {
      HiveInsert x = new HiveInsert();
      this.cloneTo(x);
      return x;
   }

   public SQLExprTableSource getTableSource() {
      return this.tableSource;
   }

   public void setTableSource(SQLExprTableSource tableSource) {
      if (tableSource != null) {
         tableSource.setParent(this);
      }

      this.tableSource = tableSource;
   }

   public void setTableSource(SQLName tableName) {
      this.setTableSource(new SQLExprTableSource(tableName));
   }

   public SQLSelect getQuery() {
      return this.query;
   }

   public void setQuery(SQLSelect query) {
      if (query != null) {
         query.setParent(this);
      }

      this.query = query;
   }

   public List<SQLInsertStatement.ValuesClause> getValuesList() {
      return this.valuesList;
   }

   public void addValueCause(SQLInsertStatement.ValuesClause valueClause) {
      if (valueClause != null) {
         valueClause.setParent(this);
      }

      this.valuesList.add(valueClause);
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor instanceof HiveASTVisitor) {
         this.accept0((HiveASTVisitor)visitor);
      } else {
         this.acceptChild(visitor, this.tableSource);
         this.acceptChild(visitor, this.partitions);
         this.acceptChild(visitor, this.valuesList);
         this.acceptChild(visitor, this.query);
      }

   }

   protected void accept0(HiveASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.tableSource);
         this.acceptChild(visitor, this.partitions);
         this.acceptChild(visitor, this.valuesList);
         this.acceptChild(visitor, this.query);
      }

      visitor.endVisit(this);
   }
}
