package com.chenyang.druid.sql.dialect.hive.ast.stmt;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLObject;
import com.chenyang.druid.sql.ast.statement.SQLAssignItem;
import com.chenyang.druid.sql.ast.statement.SQLCreateTableStatement;
import com.chenyang.druid.sql.ast.statement.SQLSelect;
import com.chenyang.druid.sql.ast.statement.SQLTableElement;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class HiveCreateTableStatement extends SQLCreateTableStatement {
   protected List<SQLExpr> skewedBy = new ArrayList();
   protected List<SQLExpr> skewedByOn = new ArrayList();
   protected Map<String, SQLObject> serdeProperties = new LinkedHashMap();
   protected SQLExpr metaLifeCycle;
   protected boolean likeQuery = false;
   protected List<SQLAssignItem> mappedBy = new ArrayList(1);
   protected SQLExpr intoBuckets;
   protected SQLExpr using;
   protected SQLSelect select;
   public String type;
   protected final List<SQLTableElement> viewColumns = new ArrayList();

   public HiveCreateTableStatement() {
      this.dbType = DbType.hive;
   }

   public HiveCreateTableStatement(DbType dbType) {
      this.dbType = dbType;
   }

   protected void accept0(SQLASTVisitor v) {
      if (v.visit(this)) {
         this.acceptChild(v);
      }

      v.endVisit(this);
   }

   protected void acceptChild(SQLASTVisitor v) {
      super.acceptChild(v);
      this.acceptChild(v, this.skewedBy);
      this.acceptChild(v, this.skewedByOn);

      for(SQLObject item : this.serdeProperties.values()) {
         this.acceptChild(v, item);
      }

      this.acceptChild(v, this.metaLifeCycle);
      this.acceptChild(v, this.intoBuckets);
   }

   public void addColumn(SQLTableElement column) {
      if (column != null) {
         column.setParent(this);
      }

      this.viewColumns.add(column);
   }

   public void cloneTo(HiveCreateTableStatement x) {
      super.cloneTo(x);

      for(SQLExpr item : this.skewedBy) {
         x.addSkewedBy(item.clone());
      }

      for(SQLExpr item : this.skewedByOn) {
         x.addSkewedByOn(item.clone());
      }

      for(Map.Entry<String, SQLObject> entry : this.serdeProperties.entrySet()) {
         SQLObject entryValue = ((SQLObject)entry.getValue()).clone();
         entryValue.setParent(x);
         x.serdeProperties.put(entry.getKey(), entryValue);
      }

      if (this.metaLifeCycle != null) {
         x.setMetaLifeCycle(this.metaLifeCycle.clone());
      }

      x.setLikeQuery(this.likeQuery);
      if (this.mappedBy != null) {
         for(SQLAssignItem item : this.mappedBy) {
            SQLAssignItem item2 = item.clone();
            item2.setParent(this);
            x.mappedBy.add(item2);
         }
      }

      if (this.intoBuckets != null) {
         x.intoBuckets = this.intoBuckets.clone();
      }

      if (this.using != null) {
         x.setUsing(this.using.clone());
      }

   }

   public HiveCreateTableStatement clone() {
      HiveCreateTableStatement x = new HiveCreateTableStatement();
      this.cloneTo(x);
      return x;
   }

   public List<SQLExpr> getSkewedBy() {
      return this.skewedBy;
   }

   public void addSkewedBy(SQLExpr item) {
      item.setParent(this);
      this.skewedBy.add(item);
   }

   public List<SQLExpr> getSkewedByOn() {
      return this.skewedByOn;
   }

   public void addSkewedByOn(SQLExpr item) {
      item.setParent(this);
      this.skewedByOn.add(item);
   }

   public Map<String, SQLObject> getSerdeProperties() {
      return this.serdeProperties;
   }

   public SQLExpr getMetaLifeCycle() {
      return this.metaLifeCycle;
   }

   public void setMetaLifeCycle(SQLExpr x) {
      if (x != null) {
         x.setParent(this);
      }

      this.metaLifeCycle = x;
   }

   public boolean isLikeQuery() {
      return this.likeQuery;
   }

   public void setLikeQuery(boolean likeQuery) {
      this.likeQuery = likeQuery;
   }

   public List<SQLAssignItem> getMappedBy() {
      return this.mappedBy;
   }

   public SQLExpr getIntoBuckets() {
      return this.intoBuckets;
   }

   public void setIntoBuckets(SQLExpr intoBuckets) {
      this.intoBuckets = intoBuckets;
   }

   public SQLExpr getUsing() {
      return this.using;
   }

   public void setUsing(SQLExpr x) {
      if (x != null) {
         x.setParent(this);
      }

      this.using = x;
   }

   public void setSelect(SQLSelect select) {
      if (select != null) {
         select.setParent(this);
      }

      this.select = select;
   }

   public SQLSelect getSelect() {
      return this.select;
   }
}
