package com.chenyang.druid.sql.dialect.hive.ast.stmt;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLStatementImpl;
import com.chenyang.druid.sql.ast.statement.SQLAssignItem;
import com.chenyang.druid.sql.ast.statement.SQLShowStatement;
import com.chenyang.druid.sql.dialect.hive.visitor.HiveASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class HiveShowStatement extends SQLStatementImpl implements HiveStatement, SQLShowStatement {
   private SQLExpr expr;
   public SQLExpr database;
   public SQLExpr like;
   public SQLExpr in;
   public SQLExpr in2;
   public SQLExpr on;
   public SQLExpr from;
   public SQLExpr from2;
   public SQLExpr other;
   public List<SQLAssignItem> partitions;
   public SQLExpr partitionsName;
   public SQLExpr conf;
   public boolean craeteTable = false;
   public boolean materialized = false;
   public boolean COMPACTIONS = false;
   public boolean isAbort = false;
   public String showType;
   public SQLExpr showTypeValue;
   public SQLExpr tableName;
   public boolean isAllTable = false;

   public SQLExpr getExpr() {
      return this.expr;
   }

   public HiveShowStatement() {
      this.dbType = DbType.hive;
   }

   public void addPartition(SQLAssignItem partition) {
      if (partition != null) {
         partition.setParent(this);
      }

      if (this.partitions == null) {
         this.partitions = new ArrayList();
      }

      this.partitions.add(partition);
   }

   public List<SQLAssignItem> getPartitions() {
      return this.partitions;
   }

   public void setExpr(SQLExpr expr) {
      this.expr = expr;
   }

   protected void accept0(SQLASTVisitor visitor) {
      this.accept0((HiveASTVisitor)visitor);
   }

   public void accept0(HiveASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.expr);
      }

      visitor.endVisit(this);
   }
}
