package com.chenyang.druid.sql.dialect.kingbase.ast.clause;

import com.chenyang.druid.sql.ast.statement.SQLWithSubqueryClause;
import com.chenyang.druid.sql.dialect.kingbase.KingbaseSQLObject;
import com.chenyang.druid.sql.dialect.kingbase.visitor.KingbaseASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;

public class KingbaseWithSubqueryEntry extends SQLWithSubqueryClause.Entry implements KingbaseSQLObject {
   protected Type type;

   public void accept0(KingbaseASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.columns);
         this.acceptChild(visitor, this.subQuery);
         this.acceptChild(visitor, this.returningStatement);
         this.acceptChild(visitor, this.expr);
      }

      visitor.endVisit(this);
   }

   protected void accept0(SQLASTVisitor visitor) {
      this.accept0((KingbaseASTVisitor)visitor);
   }

   public void cloneTo(KingbaseWithSubqueryEntry x) {
      super.cloneTo(x);
      x.type = this.type;
   }

   public KingbaseWithSubqueryEntry clone() {
      KingbaseWithSubqueryEntry x = new KingbaseWithSubqueryEntry();
      this.cloneTo(x);
      return x;
   }

   public Type getType() {
      return this.type;
   }

   public void setType(Type type) {
      this.type = type;
   }

   public static enum Type {
      MATERIALIZED("MATERIALIZED"),
      NOT_MATERIALIZED("NOT MATERIALIZED");

      public final String name;

      private Type(String name) {
         this.name = name;
      }
   }
}
