package com.chenyang.druid.sql.dialect.kingbase.ast.expression;

import com.chenyang.druid.sql.SQLUtils;
import com.chenyang.druid.sql.ast.SQLCommentHint;
import com.chenyang.druid.sql.ast.SQLDataType;
import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLObject;
import com.chenyang.druid.sql.ast.expr.SQLValuableExpr;
import com.chenyang.druid.sql.dialect.kingbase.KingbaseExpr;
import com.chenyang.druid.sql.dialect.kingbase.visitor.KingbaseASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTOutputVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import util.sqlparse.visitor.common.Objects;

public class KingbaseConstantExpr implements KingbaseExpr, SQLValuableExpr {
   private String value;
   private SQLObject parent;
   private Map<String, Object> attributes = new HashMap();

   public void accept0(KingbaseASTVisitor visitor) {
      visitor.visit(this);
      visitor.endVisit(this);
   }

   public void accept(SQLASTVisitor visitor) {
      this.accept0((KingbaseASTVisitor)visitor);
   }

   public SQLExpr clone() {
      KingbaseConstantExpr e = new KingbaseConstantExpr();
      e.value = this.value;
      return e;
   }

   public SQLObject getParent() {
      return this.parent;
   }

   public void setParent(SQLObject parent) {
      this.parent = parent;
   }

   public Map<String, Object> getAttributes() {
      return this.attributes;
   }

   public boolean containsAttribute(String name) {
      return this.attributes.containsKey(name);
   }

   public Object getAttribute(String name) {
      return this.attributes.get(name);
   }

   public void putAttribute(String name, Object value) {
      this.attributes.put(name, value);
   }

   public Map<String, Object> getAttributesDirect() {
      return this.attributes;
   }

   public void output(StringBuffer buf) {
      this.output((Appendable)buf);
   }

   public void output(Appendable buf) {
      this.accept(new SQLASTOutputVisitor(buf));
   }

   public List<SQLObject> getChildren() {
      return null;
   }

   public SQLCommentHint getHint() {
      return null;
   }

   public Object getValue() {
      return this.value;
   }

   public void setValue(String value) {
      this.value = value;
   }

   public String toString() {
      return SQLUtils.toSQLString(this);
   }

   public void addBeforeComment(String comment) {
   }

   public void addBeforeComment(List<String> comments) {
   }

   public List<String> getBeforeCommentsDirect() {
      return null;
   }

   public void addAfterComment(String comment) {
   }

   public void addAfterComment(List<String> comments) {
   }

   public List<String> getAfterCommentsDirect() {
      return null;
   }

   public boolean hasBeforeComment() {
      return false;
   }

   public boolean hasAfterComment() {
      return false;
   }

   public SQLDataType computeDataType() {
      return null;
   }

   public boolean equals(Object o) {
      if (this == o) {
         return true;
      } else if (o != null && this.getClass() == o.getClass()) {
         KingbaseConstantExpr that = (KingbaseConstantExpr)o;
         return Objects.equals(this.value, that.value);
      } else {
         return false;
      }
   }

   public int hashCode() {
      return Objects.hash(this.value);
   }
}
