package com.chenyang.druid.sql.dialect.kingbase.ast.statement;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.SQLUtils;
import com.chenyang.druid.sql.ast.SQLCommentHint;
import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.statement.SQLInsertStatement;
import com.chenyang.druid.sql.ast.statement.SQLSelectItem;
import com.chenyang.druid.sql.dialect.kingbase.visitor.KingbaseASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class KingbaseInsertStatement extends SQLInsertStatement {
   private boolean lowPriority = false;
   private boolean delayed = false;
   private boolean highPriority = false;
   private boolean ignore = false;
   private boolean rollbackOnFail = false;
   private boolean fulltextDictionary = false;
   private boolean overwrite = false;
   private boolean ifNotExists = false;
   private boolean set = false;
   private boolean defaultValue = false;
   private boolean onConflict = false;
   private boolean doNothing = false;
   private boolean doUpdate = false;
   private KingbaseInsertStatement doUpdateStatement;
   private List<SQLExpr> doUpdateList = new ArrayList();
   private SQLExpr doUpdateWhere;
   private boolean setWay = false;
   private List<SQLSelectItem> returnList = new ArrayList();
   private String overridingStr = "";
   protected List<SQLCommentHint> hints;
   private final List<SQLExpr> duplicateKeyUpdate = new ArrayList();

   public KingbaseInsertStatement() {
      this.dbType = DbType.kingbase;
   }

   public void cloneTo(KingbaseInsertStatement x) {
      super.cloneTo(x);
      x.lowPriority = this.lowPriority;
      x.delayed = this.delayed;
      x.highPriority = this.highPriority;
      x.ignore = this.ignore;
      x.rollbackOnFail = this.rollbackOnFail;
      x.fulltextDictionary = this.fulltextDictionary;
      x.overwrite = this.overwrite;
      x.ifNotExists = this.ifNotExists;

      for(SQLExpr e : this.duplicateKeyUpdate) {
         SQLExpr e2 = e.clone();
         e2.setParent(x);
         x.duplicateKeyUpdate.add(e2);
      }

   }

   public List<SQLExpr> getDuplicateKeyUpdate() {
      return this.duplicateKeyUpdate;
   }

   public boolean isLowPriority() {
      return this.lowPriority;
   }

   public void setLowPriority(boolean lowPriority) {
      this.lowPriority = lowPriority;
   }

   public boolean isDelayed() {
      return this.delayed;
   }

   public void setDelayed(boolean delayed) {
      this.delayed = delayed;
   }

   public boolean isHighPriority() {
      return this.highPriority;
   }

   public void setHighPriority(boolean highPriority) {
      this.highPriority = highPriority;
   }

   public boolean isIgnore() {
      return this.ignore;
   }

   public void setIgnore(boolean ignore) {
      this.ignore = ignore;
   }

   public boolean isRollbackOnFail() {
      return this.rollbackOnFail;
   }

   public void setRollbackOnFail(boolean rollbackOnFail) {
      this.rollbackOnFail = rollbackOnFail;
   }

   public boolean isFulltextDictionary() {
      return this.fulltextDictionary;
   }

   public void setFulltextDictionary(boolean fulltextDictionary) {
      this.fulltextDictionary = fulltextDictionary;
   }

   public boolean isIfNotExists() {
      return this.ifNotExists;
   }

   public void setIfNotExists(boolean ifNotExists) {
      this.ifNotExists = ifNotExists;
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor instanceof KingbaseASTVisitor) {
         this.accept0((KingbaseASTVisitor)visitor);
      } else {
         super.accept0(visitor);
      }

   }

   protected void accept0(KingbaseASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.with);
         if (this.tableSource != null) {
            this.tableSource.accept(visitor);
         }

         if (this.columns != null) {
            for(SQLExpr column : this.columns) {
               if (column != null) {
                  column.accept(visitor);
               }
            }
         }

         if (this.valuesList != null) {
            for(ValuesClause values : this.valuesList) {
               if (values != null) {
                  values.accept(visitor);
               }
            }
         }

         if (this.query != null) {
            this.query.accept(visitor);
         }

         if (this.duplicateKeyUpdate != null) {
            for(SQLExpr item : this.duplicateKeyUpdate) {
               if (item != null) {
                  item.accept(visitor);
               }
            }
         }

         if (this.doUpdateStatement != null) {
            this.doUpdateStatement.accept(visitor);
         }

         if (this.doUpdateList != null) {
            for(SQLExpr sqlExpr : this.doUpdateList) {
               sqlExpr.accept(visitor);
            }
         }

         if (this.doUpdateWhere != null) {
            this.doUpdateWhere.accept(visitor);
         }
      }

      visitor.endVisit(this);
   }

   public int getHintsSize() {
      return this.hints == null ? 0 : this.hints.size();
   }

   public List<SQLCommentHint> getHints() {
      return this.hints;
   }

   public void setHints(List<SQLCommentHint> x) {
      if (x != null) {
         for(int i = 0; i < x.size(); ++i) {
            ((SQLCommentHint)x.get(i)).setParent(this);
         }
      }

      this.hints = x;
   }

   public SQLInsertStatement clone() {
      KingbaseInsertStatement x = new KingbaseInsertStatement();
      this.cloneTo(x);
      return x;
   }

   public boolean isOverwrite() {
      return this.overwrite;
   }

   public void setOverwrite(boolean overwrite) {
      this.overwrite = overwrite;
   }

   public boolean isSet() {
      return this.set;
   }

   public void setSet(boolean set) {
      this.set = set;
   }

   public boolean isDefaultValue() {
      return this.defaultValue;
   }

   public void setDefaultValue(boolean defaultValue) {
      this.defaultValue = defaultValue;
   }

   public String toString() {
      return SQLUtils.toSQLString(this, (DbType)this.dbType);
   }

   public boolean isOnConflict() {
      return this.onConflict;
   }

   public void setOnConflict(boolean onConflict) {
      this.onConflict = onConflict;
   }

   public List<SQLSelectItem> getReturnList() {
      return this.returnList;
   }

   public void setReturnList(List<SQLSelectItem> returnList) {
      this.returnList = returnList;
   }

   public boolean isDoNothing() {
      return this.doNothing;
   }

   public void setDoNothing(boolean doNothing) {
      this.doNothing = doNothing;
   }

   public List<SQLExpr> getDoUpdateList() {
      return this.doUpdateList;
   }

   public void setDoUpdateList(List<SQLExpr> doUpdateList) {
      this.doUpdateList = doUpdateList;
   }

   public boolean isDoUpdate() {
      return this.doUpdate;
   }

   public void setDoUpdate(boolean doUpdate) {
      this.doUpdate = doUpdate;
   }

   public KingbaseInsertStatement getDoUpdateStatement() {
      return this.doUpdateStatement;
   }

   public void setDoUpdateStatement(KingbaseInsertStatement doUpdateStatement) {
      this.doUpdateStatement = doUpdateStatement;
   }

   public SQLExpr getDoUpdateWhere() {
      return this.doUpdateWhere;
   }

   public void setDoUpdateWhere(SQLExpr doUpdateWhere) {
      this.doUpdateWhere = doUpdateWhere;
   }

   public boolean isSetWay() {
      return this.setWay;
   }

   public void setSetWay(boolean setWay) {
      this.setWay = setWay;
   }

   public String getOverridingStr() {
      return this.overridingStr;
   }

   public void setOverridingStr(String overridingStr) {
      this.overridingStr = overridingStr;
   }
}
