package com.chenyang.druid.sql.dialect.kingbase.visitor;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.ast.statement.SQLDeleteStatement;
import com.chenyang.druid.sql.ast.statement.SQLExprTableSource;
import com.chenyang.druid.sql.ast.statement.SQLInsertStatement;
import com.chenyang.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.chenyang.druid.sql.ast.statement.SQLUpdateStatement;
import com.chenyang.druid.sql.dialect.kingbase.ast.KingbaseValuesTableSource;
import com.chenyang.druid.sql.dialect.kingbase.ast.ValueClause;
import com.chenyang.druid.sql.dialect.kingbase.ast.clause.KingbaseSQLOver;
import com.chenyang.druid.sql.dialect.kingbase.ast.clause.KingbaseWithSubqueryEntry;
import com.chenyang.druid.sql.dialect.kingbase.ast.expression.KingbaseArgumentExpr;
import com.chenyang.druid.sql.dialect.kingbase.ast.expression.KingbaseCaseStatement;
import com.chenyang.druid.sql.dialect.kingbase.ast.expression.KingbaseCharExpr;
import com.chenyang.druid.sql.dialect.kingbase.ast.expression.KingbaseConstantExpr;
import com.chenyang.druid.sql.dialect.kingbase.ast.expression.KingbaseDateTimeExpr;
import com.chenyang.druid.sql.dialect.kingbase.ast.expression.KingbaseExprTableSource;
import com.chenyang.druid.sql.dialect.kingbase.ast.expression.KingbaseForUpdateExpr;
import com.chenyang.druid.sql.dialect.kingbase.ast.expression.KingbaseTypeCastExpr;
import com.chenyang.druid.sql.dialect.kingbase.ast.expression.KingbaseUpdateTableSource;
import com.chenyang.druid.sql.dialect.kingbase.ast.statement.KingbaseDeleteStatement;
import com.chenyang.druid.sql.dialect.kingbase.ast.statement.KingbaseInsertStatement;
import com.chenyang.druid.sql.dialect.kingbase.ast.statement.KingbaseMultiInsertStatement;
import com.chenyang.druid.sql.dialect.kingbase.ast.statement.KingbaseSelectQueryBlock;
import com.chenyang.druid.sql.dialect.kingbase.ast.statement.KingbaseUpdateStatement;
import com.chenyang.druid.sql.repository.SchemaRepository;
import com.chenyang.druid.sql.visitor.SchemaStatVisitor;

public class KingbaseSchemaStatVisitor extends SchemaStatVisitor implements KingbaseASTVisitor {
   public KingbaseSchemaStatVisitor() {
      super(DbType.kingbase);
   }

   public KingbaseSchemaStatVisitor(DbType dbType) {
      super(dbType);
   }

   public KingbaseSchemaStatVisitor(SchemaRepository repository) {
      super(repository);
   }

   public boolean visit(KingbaseExprTableSource x) {
      super.visit((SQLExprTableSource)x);
      return false;
   }

   public void endVisit(KingbaseExprTableSource x) {
   }

   public boolean visit(KingbaseWithSubqueryEntry x) {
      return true;
   }

   public void endVisit(KingbaseWithSubqueryEntry x) {
   }

   public boolean visit(KingbaseConstantExpr x) {
      return true;
   }

   public void endVisit(KingbaseConstantExpr x) {
   }

   public boolean visit(KingbaseMultiInsertStatement x) {
      return true;
   }

   public void endVisit(KingbaseMultiInsertStatement x) {
   }

   public boolean visit(KingbaseMultiInsertStatement.ConditionalInsertClause x) {
      return true;
   }

   public void endVisit(KingbaseMultiInsertStatement.ConditionalInsertClause x) {
   }

   public boolean visit(KingbaseMultiInsertStatement.ConditionalInsertClauseItem x) {
      return true;
   }

   public void endVisit(KingbaseMultiInsertStatement.ConditionalInsertClauseItem x) {
   }

   public boolean visit(KingbaseMultiInsertStatement.InsertIntoClause x) {
      return true;
   }

   public void endVisit(KingbaseMultiInsertStatement.InsertIntoClause x) {
   }

   public boolean visit(KingbaseInsertStatement x) {
      this.visit((SQLInsertStatement)x);
      return false;
   }

   public void endVisit(KingbaseInsertStatement x) {
   }

   public boolean visit(KingbaseUpdateStatement x) {
      this.visit((SQLUpdateStatement)x);
      return false;
   }

   public void endVisit(KingbaseUpdateStatement x) {
   }

   public boolean visit(KingbaseUpdateTableSource x) {
      return true;
   }

   public void endVisit(KingbaseUpdateTableSource x) {
   }

   public boolean visit(KingbaseDeleteStatement x) {
      this.visit((SQLDeleteStatement)x);
      return false;
   }

   public void endVisit(KingbaseDeleteStatement x) {
   }

   public boolean visit(KingbaseTypeCastExpr x) {
      return true;
   }

   public void endVisit(KingbaseTypeCastExpr x) {
   }

   public boolean visit(KingbaseSQLOver x) {
      return true;
   }

   public void endVisit(KingbaseSQLOver x) {
   }

   public boolean visit(KingbaseDateTimeExpr x) {
      return true;
   }

   public void endVisit(KingbaseDateTimeExpr x) {
   }

   public boolean visit(KingbaseForUpdateExpr x) {
      return true;
   }

   public void endVisit(KingbaseForUpdateExpr x) {
   }

   public boolean visit(KingbaseSelectQueryBlock x) {
      this.visit((SQLSelectQueryBlock)x);
      return false;
   }

   public void endVisit(KingbaseSelectQueryBlock x) {
   }

   public boolean visit(KingbaseArgumentExpr x) {
      return true;
   }

   public void endVisit(KingbaseArgumentExpr x) {
   }

   public boolean visit(KingbaseCharExpr x) {
      return true;
   }

   public void endVisit(KingbaseCharExpr x) {
   }

   public boolean visit(KingbaseCaseStatement.KingbaseWhenStatement x) {
      return true;
   }

   public void endVisit(KingbaseCaseStatement.KingbaseWhenStatement x) {
   }

   public boolean visit(KingbaseCaseStatement x) {
      return true;
   }

   public void endVisit(KingbaseCaseStatement x) {
   }

   public boolean visit(ValueClause x) {
      return true;
   }

   public void endVisit(ValueClause x) {
   }

   public boolean visit(ValueClause.Item x) {
      return true;
   }

   public void endVisit(ValueClause.Item x) {
   }

   public boolean visit(KingbaseValuesTableSource x) {
      this.visit((SQLExprTableSource)x);
      return false;
   }

   public void endVisit(KingbaseValuesTableSource x) {
   }
}
