package com.chenyang.druid.sql.dialect.mariadb.ast;

import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.dialect.mariadb.visitor.MariadbASTVisitor;
import java.util.ArrayList;
import java.util.List;

public abstract class MariadbIndexHintImpl extends MariadbObjectImpl implements MariadbIndexHint {
   private Option option;
   private List<SQLName> indexList = new ArrayList();

   public abstract void accept0(MariadbASTVisitor var1);

   public Option getOption() {
      return this.option;
   }

   public void setOption(Option option) {
      this.option = option;
   }

   public List<SQLName> getIndexList() {
      return this.indexList;
   }

   public void setIndexList(List<SQLName> indexList) {
      this.indexList = indexList;
   }

   public abstract MariadbIndexHintImpl clone();

   public void cloneTo(MariadbIndexHintImpl x) {
      x.option = this.option;

      for(SQLName name : this.indexList) {
         SQLName name2 = name.clone();
         name2.setParent(x);
         x.indexList.add(name2);
      }

   }
}
