package com.chenyang.druid.sql.dialect.mariadb.ast;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLIndex;
import com.chenyang.druid.sql.ast.statement.SQLTableConstraint;
import com.chenyang.druid.sql.ast.statement.SQLUnique;
import com.chenyang.druid.sql.ast.statement.SQLUniqueConstraint;
import com.chenyang.druid.sql.dialect.ads.visitor.AdsVisitor;
import com.chenyang.druid.sql.dialect.mariadb.visitor.MariadbASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;

public class MariadbKey extends SQLUnique implements SQLUniqueConstraint, SQLTableConstraint, SQLIndex {
   public MariadbKey() {
      this.dbType = DbType.mariadb;
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor instanceof MariadbASTVisitor) {
         this.accept0((MariadbASTVisitor)visitor);
      } else if (visitor instanceof AdsVisitor) {
         this.accept0((AdsVisitor)visitor);
      }

   }

   protected void accept0(AdsVisitor visitor) {
      if (visitor.visit((SQLUnique)this)) {
         this.acceptChild(visitor, this.getName());
         this.acceptChild(visitor, this.getColumns());
         this.acceptChild(visitor, this.getName());
      }

      visitor.endVisit((SQLUnique)this);
   }

   protected void accept0(MariadbASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.getName());
         this.acceptChild(visitor, this.getColumns());
         this.acceptChild(visitor, this.getName());
      }

      visitor.endVisit(this);
   }

   public String getIndexType() {
      return this.indexDefinition.getOptions().getIndexType();
   }

   public void setIndexType(String indexType) {
      this.indexDefinition.getOptions().setIndexType(indexType);
   }

   public boolean isHasConstraint() {
      return this.indexDefinition.hasConstraint();
   }

   public void setHasConstraint(boolean hasConstraint) {
      this.indexDefinition.setHasConstraint(hasConstraint);
   }

   public void cloneTo(MariadbKey x) {
      super.cloneTo(x);
   }

   public MariadbKey clone() {
      MariadbKey x = new MariadbKey();
      this.cloneTo(x);
      return x;
   }

   public SQLExpr getKeyBlockSize() {
      return this.indexDefinition.getOptions().getKeyBlockSize();
   }

   public void setKeyBlockSize(SQLExpr x) {
      this.indexDefinition.getOptions().setKeyBlockSize(x);
   }
}
