package com.chenyang.druid.sql.dialect.mariadb.ast.expr;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLExprImpl;
import com.chenyang.druid.sql.ast.SQLOrderingSpecification;
import com.chenyang.druid.sql.ast.SQLReplaceable;
import com.chenyang.druid.sql.dialect.mariadb.visitor.MariadbASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.Collections;
import java.util.List;

public class MariadbOrderingExpr extends SQLExprImpl implements MariadbExpr, SQLReplaceable {
   protected SQLExpr expr;
   protected SQLOrderingSpecification type;

   public MariadbOrderingExpr() {
   }

   public MariadbOrderingExpr(SQLExpr expr, SQLOrderingSpecification type) {
      this.setExpr(expr);
      this.type = type;
   }

   public MariadbOrderingExpr clone() {
      MariadbOrderingExpr x = new MariadbOrderingExpr();
      if (this.expr != null) {
         x.setExpr(this.expr.clone());
      }

      x.type = this.type;
      return x;
   }

   public boolean replace(SQLExpr expr, SQLExpr target) {
      if (this.expr == expr) {
         this.setExpr(target);
         return true;
      } else {
         return false;
      }
   }

   protected void accept0(SQLASTVisitor visitor) {
      MariadbASTVisitor mariadbVisitor = (MariadbASTVisitor)visitor;
      if (mariadbVisitor.visit(this) && this.expr != null) {
         this.expr.accept(visitor);
      }

      mariadbVisitor.endVisit(this);
   }

   public List getChildren() {
      return Collections.singletonList(this.expr);
   }

   public SQLExpr getExpr() {
      return this.expr;
   }

   public void setExpr(SQLExpr expr) {
      if (expr != null) {
         expr.setParent(this);
      }

      this.expr = expr;
   }

   public SQLOrderingSpecification getType() {
      return this.type;
   }

   public void setType(SQLOrderingSpecification type) {
      this.type = type;
   }

   public boolean equals(Object obj) {
      if (this == obj) {
         return true;
      } else if (obj == null) {
         return false;
      } else if (this.getClass() != obj.getClass()) {
         return false;
      } else {
         MariadbOrderingExpr other = (MariadbOrderingExpr)obj;
         if (this.expr != other.expr) {
            return false;
         } else {
            if (this.type == null) {
               if (other.type != null) {
                  return false;
               }
            } else if (!this.type.equals(other.type)) {
               return false;
            }

            return true;
         }
      }
   }

   public int hashCode() {
      int prime = 31;
      int result = 1;
      result = 31 * result + (this.expr == null ? 0 : this.expr.hashCode());
      result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
      return result;
   }
}
