package com.chenyang.druid.sql.dialect.mariadb.ast.statement;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.statement.SQLAlterTableItem;
import com.chenyang.druid.sql.dialect.mariadb.ast.MariadbObjectImpl;
import com.chenyang.druid.sql.dialect.mariadb.visitor.MariadbASTVisitor;

public class MariadbAlterTableAlterColumn extends MariadbObjectImpl implements SQLAlterTableItem {
   private SQLName column;
   private boolean dropDefault = false;
   private SQLExpr defaultExpr;
   protected boolean visible = false;
   protected boolean invisible = false;

   public void accept0(MariadbASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.column);
         this.acceptChild(visitor, this.defaultExpr);
      }

      visitor.endVisit(this);
   }

   public boolean isDropDefault() {
      return this.dropDefault;
   }

   public void setDropDefault(boolean dropDefault) {
      this.dropDefault = dropDefault;
   }

   public SQLExpr getDefaultExpr() {
      return this.defaultExpr;
   }

   public void setDefaultExpr(SQLExpr defaultExpr) {
      this.defaultExpr = defaultExpr;
   }

   public SQLName getColumn() {
      return this.column;
   }

   public void setColumn(SQLName column) {
      this.column = column;
   }

   public boolean isVisible() {
      return this.visible;
   }

   public void setVisible(boolean visible) {
      this.visible = visible;
   }

   public boolean isInvisible() {
      return this.invisible;
   }

   public void setInvisible(boolean invisible) {
      this.invisible = invisible;
   }
}
