package com.chenyang.druid.sql.dialect.mariadb.ast.statement;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.statement.SQLCreateStatement;
import com.chenyang.druid.sql.dialect.mariadb.visitor.MariadbASTVisitor;

public class MariadbCreateTableSpaceStatement extends MariadbStatementImpl implements SQLCreateStatement {
   private SQLName name;
   private SQLExpr addDataFile;
   private SQLExpr initialSize;
   private SQLExpr extentSize;
   private SQLExpr autoExtentSize;
   private SQLExpr fileBlockSize;
   private SQLExpr logFileGroup;
   private SQLExpr maxSize;
   private SQLExpr nodeGroup;
   private boolean wait;
   private SQLExpr comment;
   private SQLExpr engine;

   public void accept0(MariadbASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.name);
         this.acceptChild(visitor, this.addDataFile);
         this.acceptChild(visitor, this.initialSize);
         this.acceptChild(visitor, this.extentSize);
         this.acceptChild(visitor, this.autoExtentSize);
         this.acceptChild(visitor, this.fileBlockSize);
         this.acceptChild(visitor, this.logFileGroup);
         this.acceptChild(visitor, this.maxSize);
         this.acceptChild(visitor, this.nodeGroup);
         this.acceptChild(visitor, this.comment);
         this.acceptChild(visitor, this.engine);
      }

      visitor.endVisit(this);
   }

   public SQLName getName() {
      return this.name;
   }

   public void setName(SQLName x) {
      if (x != null) {
         x.setParent(this);
      }

      this.name = x;
   }

   public SQLExpr getAddDataFile() {
      return this.addDataFile;
   }

   public void setAddDataFile(SQLExpr x) {
      if (x != null) {
         x.setParent(this);
      }

      this.addDataFile = this.addDataFile;
   }

   public SQLExpr getInitialSize() {
      return this.initialSize;
   }

   public void setInitialSize(SQLExpr x) {
      if (x != null) {
         x.setParent(this);
      }

      this.initialSize = x;
   }

   public SQLExpr getFileBlockSize() {
      return this.fileBlockSize;
   }

   public void setFileBlockSize(SQLExpr x) {
      if (x != null) {
         x.setParent(this);
      }

      this.fileBlockSize = x;
   }

   public boolean isWait() {
      return this.wait;
   }

   public void setWait(boolean wait) {
      this.wait = wait;
   }

   public SQLExpr getEngine() {
      return this.engine;
   }

   public void setEngine(SQLExpr x) {
      if (x != null) {
         x.setParent(this);
      }

      this.engine = this.engine;
   }

   public SQLExpr getLogFileGroup() {
      return this.logFileGroup;
   }

   public void setLogFileGroup(SQLExpr x) {
      if (x != null) {
         x.setParent(this);
      }

      this.logFileGroup = x;
   }

   public SQLExpr getExtentSize() {
      return this.extentSize;
   }

   public void setExtentSize(SQLExpr x) {
      if (x != null) {
         x.setParent(this);
      }

      this.extentSize = x;
   }

   public SQLExpr getAutoExtentSize() {
      return this.autoExtentSize;
   }

   public void setAutoExtentSize(SQLExpr x) {
      if (x != null) {
         x.setParent(this);
      }

      this.autoExtentSize = x;
   }

   public SQLExpr getMaxSize() {
      return this.maxSize;
   }

   public void setMaxSize(SQLExpr x) {
      if (x != null) {
         x.setParent(this);
      }

      this.maxSize = x;
   }

   public SQLExpr getNodeGroup() {
      return this.nodeGroup;
   }

   public void setNodeGroup(SQLExpr x) {
      if (x != null) {
         x.setParent(this);
      }

      this.nodeGroup = x;
   }

   public SQLExpr getComment() {
      return this.comment;
   }

   public void setComment(SQLExpr x) {
      if (x != null) {
         x.setParent(this);
      }

      this.comment = x;
   }
}
