package com.chenyang.druid.sql.dialect.mariadb.ast.statement;

import com.chenyang.druid.sql.SQLUtils;
import com.chenyang.druid.sql.ast.SQLCommentHint;
import com.chenyang.druid.sql.ast.SQLStatement;
import com.chenyang.druid.sql.dialect.mariadb.visitor.MariadbASTVisitor;
import java.util.List;

public class MariadbHintStatement extends MariadbStatementImpl {
   private List<SQLCommentHint> hints;
   private List<SQLStatement> hintStatements;

   public void accept0(MariadbASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.hints);
      }

      visitor.endVisit(this);
   }

   public List<SQLCommentHint> getHints() {
      return this.hints;
   }

   public void setHints(List<SQLCommentHint> hints) {
      this.hints = hints;
   }

   public int getHintVersion() {
      if (this.hints.size() != 1) {
         return -1;
      } else {
         SQLCommentHint hint = (SQLCommentHint)this.hints.get(0);
         String text = hint.getText();
         if (text.length() < 7) {
            return -1;
         } else {
            char c0 = text.charAt(0);
            char c1 = text.charAt(1);
            char c2 = text.charAt(2);
            char c3 = text.charAt(3);
            char c4 = text.charAt(4);
            char c5 = text.charAt(5);
            char c6 = text.charAt(6);
            if (c0 != '!') {
               return -1;
            } else {
               return c1 >= '0' && c1 <= '9' && c2 >= '0' && c2 <= '9' && c3 >= '0' && c3 <= '9' && c4 >= '0' && c4 <= '9' && c5 >= '0' && c5 <= '9' && c6 == ' ' ? (c1 - 48) * 10000 + (c2 - 48) * 1000 + (c3 - 48) * 100 + (c4 - 48) * 10 + (c5 - 48) : -1;
            }
         }
      }
   }

   public List<SQLStatement> getHintStatements() {
      if (this.hintStatements != null) {
         return this.hintStatements;
      } else if (this.hints.size() != 1) {
         return null;
      } else {
         SQLCommentHint hint = (SQLCommentHint)this.hints.get(0);
         String text = hint.getText();
         if (text.length() < 7) {
            return null;
         } else {
            char c0 = text.charAt(0);
            char c1 = text.charAt(1);
            char c2 = text.charAt(2);
            char c3 = text.charAt(3);
            char c4 = text.charAt(4);
            char c5 = text.charAt(5);
            char c6 = text.charAt(6);
            if (c0 != '!') {
               return null;
            } else {
               int start;
               if (c1 == ' ') {
                  start = 2;
               } else {
                  if (c1 < '0' || c1 > '9' || c2 < '0' || c2 > '9' || c3 < '0' || c3 > '9' || c4 < '0' || c4 > '9' || c5 < '0' || c5 > '9' || c6 != ' ') {
                     return null;
                  }

                  start = 7;
               }

               String hintSql = text.substring(start);
               this.hintStatements = SQLUtils.parseStatements(hintSql, this.dbType);
               return this.hintStatements;
            }
         }
      }
   }
}
