package com.chenyang.druid.sql.dialect.mariadb.ast.statement;

import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.statement.SQLAlterStatement;
import com.chenyang.druid.sql.dialect.mariadb.visitor.MariadbASTVisitor;

public class MariadbRenameSequenceStatement extends MariadbStatementImpl implements SQLAlterStatement {
   private SQLName name;
   private SQLName to;

   public void accept0(MariadbASTVisitor v) {
      if (v.visit(this)) {
         if (this.name != null) {
            this.name.accept(v);
         }

         if (this.to != null) {
            this.to.accept(v);
         }
      }

      v.endVisit(this);
   }

   public SQLName getName() {
      return this.name;
   }

   public void setName(SQLName x) {
      if (x != null) {
         x.setParent(this);
      }

      this.name = x;
   }

   public SQLName getTo() {
      return this.to;
   }

   public void setTo(SQLName x) {
      if (x != null) {
         x.setParent(this);
      }

      this.to = x;
   }
}
