package com.chenyang.druid.sql.dialect.mariadb.ast.statement;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLObject;
import com.chenyang.druid.sql.dialect.mariadb.visitor.MariadbASTVisitor;
import java.util.Arrays;
import java.util.List;

public class MariadbShowCharacterSetStatement extends MariadbStatementImpl implements MariadbShowStatement {
   private SQLExpr where;
   private SQLExpr pattern;

   public void accept0(MariadbASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.where);
         this.acceptChild(visitor, this.pattern);
      }

      visitor.endVisit(this);
   }

   public SQLExpr getWhere() {
      return this.where;
   }

   public void setWhere(SQLExpr where) {
      this.where = where;
   }

   public SQLExpr getPattern() {
      return this.pattern;
   }

   public void setPattern(SQLExpr pattern) {
      this.pattern = pattern;
   }

   public List<SQLObject> getChildren() {
      return Arrays.asList(this.where, this.pattern);
   }
}
