package com.chenyang.druid.sql.dialect.mysql.ast.expr;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLExprImpl;
import com.chenyang.druid.sql.dialect.mysql.visitor.MySqlASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;

public class MySqlIntervalExpr extends SQLExprImpl {
   private SQLExpr value;
   private SQLExpr unit;

   public boolean equals(Object o) {
      if (o == null) {
         return false;
      } else if (!o.getClass().equals(MySqlIntervalExpr.class)) {
         return false;
      } else {
         return o == this;
      }
   }

   public int hashCode() {
      return this.value.hashCode() + this.unit.hashCode();
   }

   protected void accept0(SQLASTVisitor v) {
      if (v instanceof MySqlASTVisitor) {
         MySqlASTVisitor visitor = (MySqlASTVisitor)v;
         if (visitor.visit(this)) {
            this.acceptChild(visitor, this.value);
            this.acceptChild(visitor, this.unit);
         }

         visitor.endVisit(this);
      }

   }

   public SQLExpr clone() {
      MySqlIntervalExpr expr = new MySqlIntervalExpr();
      expr.value = this.value.clone();
      expr.unit = this.unit.clone();
      return expr;
   }

   public SQLExpr getValue() {
      return this.value;
   }

   public void setValue(SQLExpr value) {
      value.setParent(this);
      this.value = value;
   }

   public SQLExpr getUnit() {
      return this.unit;
   }

   public void setUnit(SQLExpr unit) {
      this.unit = unit;
   }
}
