package com.chenyang.druid.sql.dialect.mysql.ast.statement;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.ast.statement.SQLRevokeStatement;
import com.chenyang.druid.sql.dialect.mysql.visitor.MySqlASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;

public class MySqLRevokeStatement extends SQLRevokeStatement implements MySqlStatement {
   private boolean ignoreUnknownUser;
   private boolean ifExists;

   public MySqLRevokeStatement(DbType dbType) {
      super(dbType);
   }

   public void accept0(MySqlASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.privileges);
         this.acceptChild(visitor, this.resource);
         this.acceptChild(visitor, this.users);
      }

      visitor.endVisit(this);
   }

   protected void accept0(SQLASTVisitor visitor) {
      this.accept0((MySqlASTVisitor)visitor);
   }

   public boolean isIfExists() {
      return this.ifExists;
   }

   public void setIfExists(boolean ifExists) {
      this.ifExists = ifExists;
   }

   public boolean isIgnoreUnknownUser() {
      return this.ignoreUnknownUser;
   }

   public void setIgnoreUnknownUser(boolean ignoreUnknownUser) {
      this.ignoreUnknownUser = ignoreUnknownUser;
   }
}
