package com.chenyang.druid.sql.dialect.mysql.ast.statement;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.statement.SQLAnalyzeTableStatement;
import com.chenyang.druid.sql.ast.statement.SQLExprTableSource;
import com.chenyang.druid.sql.dialect.mysql.visitor.MySqlASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class MySqlAnalyzeStatement extends SQLAnalyzeTableStatement implements MySqlStatement {
   private boolean noWriteToBinlog = false;
   private boolean local = false;
   private boolean update;
   private boolean drop;
   private boolean with;
   private boolean buckets;
   private boolean using;
   private SQLExpr n;
   private String jsonData;
   private List<SQLExpr> IdentifiedByColumns = new ArrayList();

   public MySqlAnalyzeStatement() {
      super.dbType = DbType.mysql;
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor instanceof MySqlASTVisitor) {
         this.accept0((MySqlASTVisitor)visitor);
      } else {
         super.accept0(visitor);
      }

   }

   public void accept0(MySqlASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.tableSources);
      }

      visitor.endVisit(this);
   }

   public boolean isNoWriteToBinlog() {
      return this.noWriteToBinlog;
   }

   public void setNoWriteToBinlog(boolean noWriteToBinlog) {
      this.noWriteToBinlog = noWriteToBinlog;
   }

   public boolean isLocal() {
      return this.local;
   }

   public void setLocal(boolean local) {
      this.local = local;
   }

   public List<SQLExprTableSource> getTableSources() {
      return this.tableSources;
   }

   public void addTableSource(SQLExprTableSource tableSource) {
      if (tableSource != null) {
         tableSource.setParent(this);
      }

      this.tableSources.add(tableSource);
   }

   public boolean isUpdate() {
      return this.update;
   }

   public void setUpdate(boolean update) {
      this.update = update;
   }

   public boolean isDrop() {
      return this.drop;
   }

   public void setDrop(boolean drop) {
      this.drop = drop;
   }

   public boolean isWith() {
      return this.with;
   }

   public void setWith(boolean with) {
      this.with = with;
   }

   public boolean isBuckets() {
      return this.buckets;
   }

   public void setBuckets(boolean buckets) {
      this.buckets = buckets;
   }

   public SQLExpr getN() {
      return this.n;
   }

   public void setN(SQLExpr n) {
      this.n = n;
   }

   public List<SQLExpr> getIdentifiedByColumns() {
      return this.IdentifiedByColumns;
   }

   public void setIdentifiedByColumns(List<SQLExpr> identifiedByColumns) {
      this.IdentifiedByColumns = identifiedByColumns;
   }

   public boolean isUsing() {
      return this.using;
   }

   public void setUsing(boolean using) {
      this.using = using;
   }

   public String getJsonData() {
      return this.jsonData;
   }

   public void setJsonData(String jsonData) {
      this.jsonData = jsonData;
   }
}
