package com.chenyang.druid.sql.dialect.mysql.ast.statement;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.statement.SQLAlterStatement;
import com.chenyang.druid.sql.dialect.mysql.visitor.MySqlASTVisitor;
import java.util.HashMap;
import java.util.Map;

public class MySqlCreateExternalCatalogStatement extends MySqlStatementImpl implements SQLAlterStatement {
   private SQLName name;
   private boolean ifNotExists;
   private Map<SQLName, SQLName> properties = new HashMap();
   private SQLName comment;

   public MySqlCreateExternalCatalogStatement() {
      this.setDbType(DbType.mysql);
   }

   public SQLName getName() {
      return this.name;
   }

   public void setName(SQLName name) {
      if (name != null) {
         name.setParent(this);
      }

      this.name = name;
   }

   public SQLName getComment() {
      return this.comment;
   }

   public void setComment(SQLName comment) {
      if (comment != null) {
         comment.setParent(this);
      }

      this.comment = comment;
   }

   public Map<SQLName, SQLName> getProperties() {
      return this.properties;
   }

   public boolean isIfNotExists() {
      return this.ifNotExists;
   }

   public void setIfNotExists(boolean ifNotExists) {
      this.ifNotExists = ifNotExists;
   }

   public void accept0(MySqlASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.name);
         this.acceptChild(visitor, this.comment);
      }

      visitor.endVisit(this);
   }
}
