package com.chenyang.druid.sql.dialect.mysql.ast.statement;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLPartitionBy;
import com.chenyang.druid.sql.dialect.mysql.ast.MySqlObject;
import com.chenyang.druid.sql.dialect.mysql.visitor.MySqlASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;

public class MySqlPartitionByKey extends SQLPartitionBy implements MySqlObject {
   private int algorithm = 2;

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor instanceof MySqlASTVisitor) {
         this.accept0((MySqlASTVisitor)visitor);
      } else {
         throw new IllegalArgumentException("not support visitor type : " + visitor.getClass().getName());
      }
   }

   public void accept0(MySqlASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.columns);
         this.acceptChild(visitor, this.partitionsCount);
         this.acceptChild(visitor, this.getPartitions());
         this.acceptChild(visitor, this.subPartitionBy);
      }

      visitor.endVisit(this);
   }

   public void cloneTo(MySqlPartitionByKey x) {
      super.cloneTo(x);

      for(SQLExpr column : this.columns) {
         SQLExpr c2 = column.clone();
         c2.setParent(x);
         x.columns.add(c2);
      }

      x.algorithm = this.algorithm;
   }

   public MySqlPartitionByKey clone() {
      MySqlPartitionByKey x = new MySqlPartitionByKey();
      this.cloneTo(x);
      return x;
   }

   public int getAlgorithm() {
      return this.algorithm;
   }

   public void setAlgorithm(int algorithm) {
      this.algorithm = algorithm;
   }
}
