package com.chenyang.druid.sql.dialect.mysql.ast.statement;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLLimit;
import com.chenyang.druid.sql.dialect.mysql.visitor.MySqlASTVisitor;

public class MySqlShowBinLogEventsStatement extends MySqlStatementImpl implements MySqlShowStatement {
   private SQLExpr in;
   private SQLExpr from;
   private SQLLimit limit;

   public void accept0(MySqlASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.in);
         this.acceptChild(visitor, this.from);
         this.acceptChild(visitor, this.limit);
      }

      visitor.endVisit(this);
   }

   public SQLExpr getIn() {
      return this.in;
   }

   public void setIn(SQLExpr in) {
      this.in = in;
   }

   public SQLExpr getFrom() {
      return this.from;
   }

   public void setFrom(SQLExpr from) {
      this.from = from;
   }

   public SQLLimit getLimit() {
      return this.limit;
   }

   public void setLimit(SQLLimit limit) {
      if (limit != null) {
         limit.setParent(this);
      }

      this.limit = limit;
   }
}
