package com.chenyang.druid.sql.dialect.mysql.ast.statement;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.SQLSubPartitionBy;
import com.chenyang.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.chenyang.druid.sql.dialect.mysql.ast.MySqlObject;
import com.chenyang.druid.sql.dialect.mysql.visitor.MySqlASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class MySqlSubPartitionByValue extends SQLSubPartitionBy implements MySqlObject {
   private List<SQLExpr> columns = new ArrayList();

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor instanceof MySqlASTVisitor) {
         this.accept0((MySqlASTVisitor)visitor);
      } else {
         throw new IllegalArgumentException("not support visitor type : " + visitor.getClass().getName());
      }
   }

   public void accept0(MySqlASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.columns);
         this.acceptChild(visitor, this.subPartitionsCount);
      }

      visitor.endVisit(this);
   }

   public List<SQLExpr> getColumns() {
      return this.columns;
   }

   public void addColumn(SQLExpr column) {
      if (column != null) {
         column.setParent(this);
      }

      this.columns.add(column);
   }

   public void cloneTo(MySqlSubPartitionByValue x) {
      super.cloneTo(x);

      for(SQLExpr column : this.columns) {
         SQLExpr c2 = column.clone();
         c2.setParent(x);
         x.columns.add(c2);
      }

   }

   public MySqlSubPartitionByValue clone() {
      MySqlSubPartitionByValue x = new MySqlSubPartitionByValue();
      this.cloneTo(x);
      return x;
   }

   public boolean isPartitionByColumn(long columnNameHashCode64) {
      for(SQLExpr column : this.columns) {
         if (column instanceof SQLName) {
            if (((SQLName)column).nameHashCode64() == columnNameHashCode64) {
               return true;
            }

            if (column instanceof SQLMethodInvokeExpr) {
               for(SQLExpr argument : ((SQLMethodInvokeExpr)column).getArguments()) {
                  if (((SQLName)argument).nameHashCode64() == columnNameHashCode64) {
                     return true;
                  }
               }
            }
         }
      }

      return false;
   }
}
