package com.chenyang.druid.sql.dialect.oracle.ast;

import com.chenyang.druid.sql.ast.SQLDataTypeImpl;
import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.dialect.oracle.visitor.OracleASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class OracleDataTypeIntervalDay extends SQLDataTypeImpl implements OracleSQLObject {
   private boolean toSecond = false;
   protected final List<SQLExpr> fractionalSeconds = new ArrayList();

   public OracleDataTypeIntervalDay() {
      this.setName("INTERVAL DAY");
   }

   protected void accept0(SQLASTVisitor visitor) {
      this.accept0((OracleASTVisitor)visitor);
   }

   public void accept0(OracleASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.getArguments());
      }

      visitor.endVisit(this);
   }

   public boolean isToSecond() {
      return this.toSecond;
   }

   public void setToSecond(boolean toSecond) {
      this.toSecond = toSecond;
   }

   public List<SQLExpr> getFractionalSeconds() {
      return this.fractionalSeconds;
   }

   public OracleDataTypeIntervalDay clone() {
      OracleDataTypeIntervalDay x = new OracleDataTypeIntervalDay();
      super.cloneTo(x);

      for(SQLExpr arg : this.fractionalSeconds) {
         arg.setParent(x);
         x.fractionalSeconds.add(arg);
      }

      return x;
   }
}
