package com.chenyang.druid.sql.dialect.oracle.ast;

import com.chenyang.druid.sql.SQLUtils;
import com.chenyang.druid.sql.ast.SQLDataType;
import com.chenyang.druid.sql.ast.SQLObjectImpl;
import com.chenyang.druid.sql.dialect.oracle.visitor.OracleASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTOutputVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;

public abstract class OracleSQLObjectImpl extends SQLObjectImpl implements OracleSQLObject {
   protected void accept0(SQLASTVisitor v) {
      if (v instanceof OracleASTVisitor) {
         this.accept0((OracleASTVisitor)v);
      } else {
         if (v instanceof SQLASTOutputVisitor) {
            ((SQLASTOutputVisitor)v).print(this.toString());
         }

      }
   }

   public abstract void accept0(OracleASTVisitor var1);

   public OracleSQLObject clone() {
      throw new UnsupportedOperationException(this.getClass().getName());
   }

   public SQLDataType computeDataType() {
      return null;
   }

   public String toString() {
      return SQLUtils.toOracleString(this);
   }
}
