package com.chenyang.druid.sql.dialect.oracle.ast;

import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.SQLObject;
import com.chenyang.druid.sql.ast.SQLObjectImpl;

public abstract class OracleSegmentAttributesImpl extends SQLObjectImpl implements OracleSegmentAttributes {
   private Integer pctfree;
   private Integer pctused;
   private Integer initrans;
   private Integer maxtrans;
   private Integer pctincrease;
   private Integer freeLists;
   private Boolean compress;
   private Integer compressLevel;
   private boolean compressForOltp;
   private Integer pctthreshold;
   private Boolean logging;
   protected SQLName tablespace;
   protected SQLObject storage;

   public SQLName getTablespace() {
      return this.tablespace;
   }

   public void setTablespace(SQLName x) {
      if (x != null) {
         x.setParent(this);
      }

      this.tablespace = x;
   }

   public Boolean getCompress() {
      return this.compress;
   }

   public void setCompress(Boolean compress) {
      this.compress = compress;
   }

   public Integer getCompressLevel() {
      return this.compressLevel;
   }

   public void setCompressLevel(Integer compressLevel) {
      this.compressLevel = compressLevel;
   }

   public Integer getPctthreshold() {
      return this.pctthreshold;
   }

   public void setPctthreshold(Integer pctthreshold) {
      this.pctthreshold = pctthreshold;
   }

   public Integer getPctfree() {
      return this.pctfree;
   }

   public void setPctfree(Integer ptcfree) {
      this.pctfree = ptcfree;
   }

   public Integer getPctused() {
      return this.pctused;
   }

   public void setPctused(Integer ptcused) {
      this.pctused = ptcused;
   }

   public Integer getInitrans() {
      return this.initrans;
   }

   public void setInitrans(Integer initrans) {
      this.initrans = initrans;
   }

   public Integer getMaxtrans() {
      return this.maxtrans;
   }

   public void setMaxtrans(Integer maxtrans) {
      this.maxtrans = maxtrans;
   }

   public Integer getPctincrease() {
      return this.pctincrease;
   }

   public void setPctincrease(Integer pctincrease) {
      this.pctincrease = pctincrease;
   }

   public Integer getFreeLists() {
      return this.freeLists;
   }

   public void setFreeLists(Integer freeLists) {
      this.freeLists = freeLists;
   }

   public Boolean getLogging() {
      return this.logging;
   }

   public void setLogging(Boolean logging) {
      this.logging = logging;
   }

   public SQLObject getStorage() {
      return this.storage;
   }

   public void setStorage(SQLObject storage) {
      this.storage = storage;
   }

   public boolean isCompressForOltp() {
      return this.compressForOltp;
   }

   public void setCompressForOltp(boolean compressForOltp) {
      this.compressForOltp = compressForOltp;
   }

   public void cloneTo(OracleSegmentAttributesImpl x) {
      x.pctfree = this.pctfree;
      x.pctused = this.pctused;
      x.initrans = this.initrans;
      x.maxtrans = this.maxtrans;
      x.pctincrease = this.pctincrease;
      x.freeLists = this.freeLists;
      x.compress = this.compress;
      x.compressLevel = this.compressLevel;
      x.compressForOltp = this.compressForOltp;
      x.pctthreshold = this.pctthreshold;
      x.logging = this.logging;
      if (this.tablespace != null) {
         x.setTablespace(this.tablespace.clone());
      }

      if (this.storage != null) {
         x.setStorage(this.storage.clone());
      }

   }
}
