package com.chenyang.druid.sql.dialect.oracle.ast.clause;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.dialect.oracle.ast.OracleSQLObject;
import com.chenyang.druid.sql.dialect.oracle.ast.OracleSegmentAttributesImpl;
import com.chenyang.druid.sql.dialect.oracle.visitor.OracleASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class OracleLobStorageClause extends OracleSegmentAttributesImpl implements OracleSQLObject {
   private SQLName segementName;
   private final List<SQLName> items = new ArrayList();
   private boolean secureFile = false;
   private boolean basicFile = false;
   private Boolean enable;
   private SQLExpr chunk;
   private Boolean cache;
   private Boolean logging;
   private Boolean compress;
   private Boolean keepDuplicate;
   private boolean retention;
   private OracleStorageClause storageClause;
   private SQLExpr pctversion;

   protected void accept0(SQLASTVisitor visitor) {
      this.accept0((OracleASTVisitor)visitor);
   }

   public void accept0(OracleASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.segementName);
         this.acceptChild(visitor, this.items);
         this.acceptChild(visitor, this.tablespace);
      }

      visitor.endVisit(this);
   }

   public void cloneTo(OracleLobStorageClause x) {
      super.cloneTo(x);
      if (this.segementName != null) {
         x.setSegementName(this.segementName.clone());
      }

      for(SQLName item : this.items) {
         SQLName item2 = item.clone();
         item2.setParent(x);
         x.items.add(item2);
      }

      x.secureFile = this.secureFile;
      x.basicFile = this.basicFile;
      x.enable = this.enable;
      if (this.chunk != null) {
         x.setChunk(this.chunk.clone());
      }

      x.cache = this.cache;
      x.logging = this.logging;
      x.compress = this.compress;
      x.keepDuplicate = this.keepDuplicate;
      x.retention = this.retention;
      if (this.storageClause != null) {
         x.setStorageClause(this.storageClause.clone());
      }

      if (this.pctversion != null) {
         x.setPctversion(this.pctversion.clone());
      }

   }

   public OracleLobStorageClause clone() {
      OracleLobStorageClause x = new OracleLobStorageClause();
      this.cloneTo(x);
      return x;
   }

   public Boolean getEnable() {
      return this.enable;
   }

   public void setEnable(Boolean enable) {
      this.enable = enable;
   }

   public SQLExpr getChunk() {
      return this.chunk;
   }

   public void setChunk(SQLExpr chunk) {
      this.chunk = chunk;
   }

   public List<SQLName> getItems() {
      return this.items;
   }

   public boolean isSecureFile() {
      return this.secureFile;
   }

   public void setSecureFile(boolean secureFile) {
      this.secureFile = secureFile;
   }

   public boolean isBasicFile() {
      return this.basicFile;
   }

   public void setBasicFile(boolean basicFile) {
      this.basicFile = basicFile;
   }

   public Boolean getCache() {
      return this.cache;
   }

   public void setCache(Boolean cache) {
      this.cache = cache;
   }

   public Boolean getLogging() {
      return this.logging;
   }

   public void setLogging(Boolean logging) {
      this.logging = logging;
   }

   public Boolean getCompress() {
      return this.compress;
   }

   public void setCompress(Boolean compress) {
      this.compress = compress;
   }

   public Boolean getKeepDuplicate() {
      return this.keepDuplicate;
   }

   public void setKeepDuplicate(Boolean keepDuplicate) {
      this.keepDuplicate = keepDuplicate;
   }

   public boolean isRetention() {
      return this.retention;
   }

   public void setRetention(boolean retention) {
      this.retention = retention;
   }

   public OracleStorageClause getStorageClause() {
      return this.storageClause;
   }

   public void setStorageClause(OracleStorageClause storageClause) {
      if (storageClause != null) {
         storageClause.setParent(this);
      }

      this.storageClause = storageClause;
   }

   public SQLExpr getPctversion() {
      return this.pctversion;
   }

   public void setPctversion(SQLExpr pctversion) {
      if (pctversion != null) {
         pctversion.setParent(this);
      }

      this.pctversion = pctversion;
   }

   public SQLName getSegementName() {
      return this.segementName;
   }

   public void setSegementName(SQLName segementName) {
      this.segementName = segementName;
   }
}
