package com.chenyang.druid.sql.dialect.oracle.ast.clause;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLReplaceable;
import com.chenyang.druid.sql.dialect.oracle.ast.OracleSQLObjectImpl;
import com.chenyang.druid.sql.dialect.oracle.visitor.OracleASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class OracleReturningClause extends OracleSQLObjectImpl implements SQLReplaceable {
   private List<SQLExpr> items = new ArrayList();
   private List<SQLExpr> values = new ArrayList();

   public List<SQLExpr> getItems() {
      return this.items;
   }

   public void addItem(SQLExpr item) {
      if (item != null) {
         item.setParent(this);
      }

      this.items.add(item);
   }

   public List<SQLExpr> getValues() {
      return this.values;
   }

   public void addValue(SQLExpr value) {
      if (value != null) {
         value.setParent(this);
      }

      this.values.add(value);
   }

   public void accept0(OracleASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.items);
         this.acceptChild(visitor, this.values);
      }

      visitor.endVisit(this);
   }

   public OracleReturningClause clone() {
      OracleReturningClause x = new OracleReturningClause();

      for(SQLExpr item : this.items) {
         SQLExpr item2 = item.clone();
         item2.setParent(x);
         x.items.add(item2);
      }

      for(SQLExpr v : this.values) {
         SQLExpr v2 = v.clone();
         v2.setParent(x);
         x.values.add(v2);
      }

      return x;
   }

   public boolean replace(SQLExpr expr, SQLExpr target) {
      for(int i = this.items.size() - 1; i >= 0; --i) {
         if (this.items.get(i) == expr) {
            target.setParent(this);
            this.items.set(i, target);
            return true;
         }
      }

      for(int i = this.values.size() - 1; i >= 0; --i) {
         if (this.values.get(i) == expr) {
            target.setParent(this);
            this.values.set(i, target);
            return true;
         }
      }

      return false;
   }
}
