package com.chenyang.druid.sql.dialect.oracle.ast.expr;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLObject;
import com.chenyang.druid.sql.ast.SQLReplaceable;
import com.chenyang.druid.sql.dialect.oracle.ast.OracleSQLObjectImpl;
import com.chenyang.druid.sql.dialect.oracle.visitor.OracleASTVisitor;
import java.util.Collections;
import java.util.List;

public class OracleArgumentExpr extends OracleSQLObjectImpl implements SQLExpr, SQLReplaceable {
   private String argumentName;
   private SQLExpr value;

   public OracleArgumentExpr() {
   }

   public OracleArgumentExpr(String argumentName, SQLExpr value) {
      this.argumentName = argumentName;
      this.setValue(value);
   }

   public String getArgumentName() {
      return this.argumentName;
   }

   public void setArgumentName(String argumentName) {
      this.argumentName = argumentName;
   }

   public SQLExpr getValue() {
      return this.value;
   }

   public void setValue(SQLExpr value) {
      if (value != null) {
         value.setParent(this);
      }

      this.value = value;
   }

   public void accept0(OracleASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.value);
      }

      visitor.endVisit(this);
   }

   public OracleArgumentExpr clone() {
      OracleArgumentExpr x = new OracleArgumentExpr();
      x.argumentName = this.argumentName;
      if (this.value != null) {
         x.setValue(this.value.clone());
      }

      return x;
   }

   public boolean replace(SQLExpr expr, SQLExpr target) {
      if (this.value == expr) {
         this.setValue(target);
         return true;
      } else {
         return false;
      }
   }

   public List<SQLObject> getChildren() {
      return Collections.singletonList(this.value);
   }
}
