package com.chenyang.druid.sql.dialect.oracle.ast.expr;

import com.chenyang.druid.sql.ast.SQLExprImpl;
import com.chenyang.druid.sql.ast.SQLObject;
import com.chenyang.druid.sql.ast.statement.SQLSelect;
import com.chenyang.druid.sql.dialect.oracle.visitor.OracleASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.Collections;
import java.util.List;

public class OracleCursorExpr extends SQLExprImpl implements OracleExpr {
   private SQLSelect query;

   public OracleCursorExpr() {
   }

   public OracleCursorExpr clone() {
      OracleCursorExpr x = new OracleCursorExpr();
      if (this.query != null) {
         x.setQuery(this.query.clone());
      }

      return x;
   }

   public OracleCursorExpr(SQLSelect query) {
      this.setQuery(query);
   }

   public SQLSelect getQuery() {
      return this.query;
   }

   public void setQuery(SQLSelect query) {
      this.query = query;
   }

   protected void accept0(SQLASTVisitor visitor) {
      this.accept0((OracleASTVisitor)visitor);
   }

   public void accept0(OracleASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.query);
      }

      visitor.endVisit(this);
   }

   public List<SQLObject> getChildren() {
      return Collections.singletonList(this.query);
   }

   public int hashCode() {
      int prime = 31;
      int result = 1;
      result = 31 * result + (this.query == null ? 0 : this.query.hashCode());
      return result;
   }

   public boolean equals(Object obj) {
      if (this == obj) {
         return true;
      } else if (obj == null) {
         return false;
      } else if (this.getClass() != obj.getClass()) {
         return false;
      } else {
         OracleCursorExpr other = (OracleCursorExpr)obj;
         if (this.query == null) {
            if (other.query != null) {
               return false;
            }
         } else if (!this.query.equals(other.query)) {
            return false;
         }

         return true;
      }
   }
}
