package com.chenyang.druid.sql.dialect.oracle.ast.expr;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLExprImpl;
import com.chenyang.druid.sql.ast.SQLObject;
import com.chenyang.druid.sql.ast.SQLReplaceable;
import com.chenyang.druid.sql.ast.expr.SQLIntegerExpr;
import com.chenyang.druid.sql.ast.expr.SQLLiteralExpr;
import com.chenyang.druid.sql.dialect.oracle.visitor.OracleASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.Collections;
import java.util.List;

public class OracleIntervalExpr extends SQLExprImpl implements SQLLiteralExpr, OracleExpr, SQLReplaceable {
   private SQLExpr value;
   private OracleIntervalType type;
   private SQLExpr precision;
   private Integer factionalSecondsPrecision;
   private OracleIntervalType toType;
   private SQLExpr toFactionalSecondsPrecision;

   public OracleIntervalExpr clone() {
      OracleIntervalExpr x = new OracleIntervalExpr();
      if (this.value != null) {
         x.setValue(this.value.clone());
      }

      x.type = this.type;
      x.precision = this.precision;
      x.factionalSecondsPrecision = this.factionalSecondsPrecision;
      x.toType = this.toType;
      x.toFactionalSecondsPrecision = this.toFactionalSecondsPrecision;
      return x;
   }

   public boolean replace(SQLExpr expr, SQLExpr target) {
      if (this.value == expr) {
         this.setValue(target);
         return true;
      } else if (this.precision == expr) {
         this.setPrecision(target);
         return true;
      } else if (this.toFactionalSecondsPrecision == expr) {
         this.setToFactionalSecondsPrecision(target);
         return true;
      } else {
         return false;
      }
   }

   public List<SQLObject> getChildren() {
      return Collections.singletonList(this.value);
   }

   public SQLExpr getValue() {
      return this.value;
   }

   public void setValue(SQLExpr value) {
      if (value != null) {
         value.setParent(this);
      }

      this.value = value;
   }

   public OracleIntervalType getType() {
      return this.type;
   }

   public void setType(OracleIntervalType type) {
      this.type = type;
   }

   public SQLExpr getPrecision() {
      return this.precision;
   }

   public void setPrecision(Integer precision) {
      this.setPrecision((SQLExpr)(new SQLIntegerExpr(precision)));
   }

   public void setPrecision(SQLExpr precision) {
      if (precision != null) {
         precision.setParent(this);
      }

      this.precision = precision;
   }

   public Integer getFactionalSecondsPrecision() {
      return this.factionalSecondsPrecision;
   }

   public void setFactionalSecondsPrecision(Integer factionalSecondsPrecision) {
      this.factionalSecondsPrecision = factionalSecondsPrecision;
   }

   public OracleIntervalType getToType() {
      return this.toType;
   }

   public void setToType(OracleIntervalType toType) {
      this.toType = toType;
   }

   public SQLExpr getToFactionalSecondsPrecision() {
      return this.toFactionalSecondsPrecision;
   }

   public void setToFactionalSecondsPrecision(SQLExpr x) {
      if (x != null) {
         x.setParent(this);
      }

      this.toFactionalSecondsPrecision = x;
   }

   protected void accept0(SQLASTVisitor visitor) {
      this.accept0((OracleASTVisitor)visitor);
   }

   public void accept0(OracleASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.value);
         this.acceptChild(visitor, this.precision);
         this.acceptChild(visitor, this.toFactionalSecondsPrecision);
      }

      visitor.endVisit(this);
   }

   public int hashCode() {
      int prime = 31;
      int result = 1;
      result = 31 * result + (this.factionalSecondsPrecision == null ? 0 : this.factionalSecondsPrecision.hashCode());
      result = 31 * result + (this.precision == null ? 0 : this.precision.hashCode());
      result = 31 * result + (this.toFactionalSecondsPrecision == null ? 0 : this.toFactionalSecondsPrecision.hashCode());
      result = 31 * result + (this.toType == null ? 0 : this.toType.hashCode());
      result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
      result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
      return result;
   }

   public boolean equals(Object obj) {
      if (this == obj) {
         return true;
      } else if (obj == null) {
         return false;
      } else if (this.getClass() != obj.getClass()) {
         return false;
      } else {
         OracleIntervalExpr other = (OracleIntervalExpr)obj;
         if (this.factionalSecondsPrecision == null) {
            if (other.factionalSecondsPrecision != null) {
               return false;
            }
         } else if (!this.factionalSecondsPrecision.equals(other.factionalSecondsPrecision)) {
            return false;
         }

         if (this.precision == null) {
            if (other.precision != null) {
               return false;
            }
         } else if (!this.precision.equals(other.precision)) {
            return false;
         }

         if (this.toFactionalSecondsPrecision == null) {
            if (other.toFactionalSecondsPrecision != null) {
               return false;
            }
         } else if (!this.toFactionalSecondsPrecision.equals(other.toFactionalSecondsPrecision)) {
            return false;
         }

         if (this.toType != other.toType) {
            return false;
         } else if (this.type != other.type) {
            return false;
         } else {
            if (this.value == null) {
               if (other.value != null) {
                  return false;
               }
            } else if (!this.value.equals(other.value)) {
               return false;
            }

            return true;
         }
      }
   }
}
