package com.chenyang.druid.sql.dialect.oracle.ast.expr;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLExprImpl;
import com.chenyang.druid.sql.ast.SQLObject;
import com.chenyang.druid.sql.ast.SQLReplaceable;
import com.chenyang.druid.sql.dialect.oracle.visitor.OracleASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.Collections;
import java.util.List;

public class OracleIsSetExpr extends SQLExprImpl implements OracleExpr, SQLReplaceable {
   private SQLExpr nestedTable;

   public OracleIsSetExpr() {
   }

   public OracleIsSetExpr(SQLExpr nestedTable) {
      this.nestedTable = nestedTable;
   }

   public OracleIsSetExpr clone() {
      OracleIsSetExpr x = new OracleIsSetExpr();
      if (this.nestedTable != null) {
         x.setNestedTable(this.nestedTable.clone());
      }

      return x;
   }

   public boolean replace(SQLExpr expr, SQLExpr target) {
      if (this.nestedTable == expr) {
         this.setNestedTable(target);
         return true;
      } else {
         return false;
      }
   }

   public SQLExpr getNestedTable() {
      return this.nestedTable;
   }

   public void setNestedTable(SQLExpr nestedTable) {
      if (nestedTable != null) {
         nestedTable.setParent(this);
      }

      this.nestedTable = nestedTable;
   }

   protected void accept0(SQLASTVisitor visitor) {
      this.accept0((OracleASTVisitor)visitor);
   }

   public void accept0(OracleASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.nestedTable);
      }

      visitor.endVisit(this);
   }

   public List<SQLObject> getChildren() {
      return Collections.singletonList(this.nestedTable);
   }

   public int hashCode() {
      int prime = 31;
      int result = 1;
      result = 31 * result + (this.nestedTable == null ? 0 : this.nestedTable.hashCode());
      return result;
   }

   public boolean equals(Object obj) {
      if (this == obj) {
         return true;
      } else if (obj == null) {
         return false;
      } else if (this.getClass() != obj.getClass()) {
         return false;
      } else {
         OracleIsSetExpr other = (OracleIsSetExpr)obj;
         if (this.nestedTable == null) {
            if (other.nestedTable != null) {
               return false;
            }
         } else if (!this.nestedTable.equals(other.nestedTable)) {
            return false;
         }

         return true;
      }
   }
}
