package com.chenyang.druid.sql.dialect.oracle.ast.expr;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLExprImpl;
import com.chenyang.druid.sql.dialect.mysql.ast.expr.MySqlIntervalExpr;
import com.chenyang.druid.sql.dialect.oracle.visitor.OracleASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;

public class OracleMultisetExpr extends SQLExprImpl implements OracleExpr {
   private SQLExpr leftNestedTable;
   private SQLExpr type;
   private SQLExpr distinct;
   private SQLExpr rightNestedTable;

   public boolean equals(Object o) {
      if (o == null) {
         return false;
      } else if (!o.getClass().equals(MySqlIntervalExpr.class)) {
         return false;
      } else {
         return o == this;
      }
   }

   public int hashCode() {
      int distinctHash = this.distinct == null ? 0 : this.distinct.hashCode();
      return this.leftNestedTable.hashCode() + this.rightNestedTable.hashCode() + this.type.hashCode() + distinctHash;
   }

   protected void accept0(SQLASTVisitor v) {
      this.accept0((OracleASTVisitor)v);
   }

   public SQLExpr clone() {
      OracleMultisetExpr expr = new OracleMultisetExpr();
      expr.leftNestedTable = this.leftNestedTable.clone();
      expr.rightNestedTable = this.rightNestedTable.clone();
      expr.type = this.type.clone();
      if (expr.distinct != null) {
         expr.distinct = this.distinct.clone();
      }

      return expr;
   }

   public SQLExpr getLeftNestedTable() {
      return this.leftNestedTable;
   }

   public void setLeftNestedTable(SQLExpr leftNestedTable) {
      this.leftNestedTable = leftNestedTable;
   }

   public SQLExpr getRightNestedTable() {
      return this.rightNestedTable;
   }

   public void setRightNestedTable(SQLExpr rightNestedTable) {
      this.rightNestedTable = rightNestedTable;
   }

   public SQLExpr getType() {
      return this.type;
   }

   public void setType(SQLExpr type) {
      this.type = type;
   }

   public SQLExpr getDistinct() {
      return this.distinct;
   }

   public void setDistinct(SQLExpr distinct) {
      this.distinct = distinct;
   }

   public void accept0(OracleASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.leftNestedTable);
         this.acceptChild(visitor, this.rightNestedTable);
         this.acceptChild(visitor, this.type);
         this.acceptChild(visitor, this.distinct);
      }

      visitor.endVisit(this);
   }
}
