package com.chenyang.druid.sql.dialect.oracle.ast.stmt;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.ast.SQLHint;
import com.chenyang.druid.sql.ast.statement.SQLDeleteStatement;
import com.chenyang.druid.sql.dialect.oracle.ast.clause.OracleReturningClause;
import com.chenyang.druid.sql.dialect.oracle.visitor.OracleASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class OracleDeleteStatement extends SQLDeleteStatement {
   private final List<SQLHint> hints = new ArrayList();
   private OracleReturningClause returning = null;

   public OracleDeleteStatement() {
      super(DbType.oracle);
   }

   public OracleReturningClause getReturning() {
      return this.returning;
   }

   public void setReturning(OracleReturningClause returning) {
      this.returning = returning;
   }

   public List<SQLHint> getHints() {
      return this.hints;
   }

   protected void accept0(SQLASTVisitor visitor) {
      this.accept0((OracleASTVisitor)visitor);
   }

   protected void accept0(OracleASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.hints);
         this.acceptChild(visitor, this.tableSource);
         this.acceptChild(visitor, this.getWhere());
         this.acceptChild(visitor, this.returning);
      }

      visitor.endVisit(this);
   }

   public OracleDeleteStatement clone() {
      OracleDeleteStatement x = new OracleDeleteStatement();
      this.cloneTo(x);

      for(SQLHint hint : this.hints) {
         SQLHint hint2 = hint.clone();
         hint2.setParent(x);
         x.hints.add(hint2);
      }

      if (this.returning != null) {
         x.setReturning(this.returning.clone());
      }

      return x;
   }
}
