package com.chenyang.druid.sql.dialect.oracle.ast.stmt;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.SQLUtils;
import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.statement.SQLExplainStatement;
import com.chenyang.druid.sql.dialect.oracle.visitor.OracleASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;

public class OracleExplainStatement extends SQLExplainStatement implements OracleStatement {
   private SQLExpr statementId;
   private SQLExpr into;

   public OracleExplainStatement() {
      super(DbType.oracle);
   }

   public void accept0(OracleASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.statementId);
         this.acceptChild(visitor, this.into);
         this.acceptChild(visitor, this.statement);
      }

      visitor.endVisit(this);
   }

   protected void accept0(SQLASTVisitor visitor) {
      this.accept0((OracleASTVisitor)visitor);
   }

   public String toString() {
      return SQLUtils.toOracleString(this);
   }

   public SQLExpr getStatementId() {
      return this.statementId;
   }

   public void setStatementId(SQLExpr statementId) {
      this.statementId = statementId;
   }

   public SQLExpr getInto() {
      return this.into;
   }

   public void setInto(SQLExpr into) {
      this.into = into;
   }
}
