package com.chenyang.druid.sql.dialect.oracle.ast.stmt;

import com.chenyang.druid.sql.ast.SQLCommentHint;
import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.dialect.oracle.visitor.OracleASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class OraclePipeRowStatement extends OracleStatementImpl {
   private final List<SQLExpr> parameters = new ArrayList();

   public void accept0(OracleASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.parameters);
      }

      visitor.endVisit(this);
   }

   public List<SQLExpr> getParameters() {
      return this.parameters;
   }

   public OraclePipeRowStatement clone() {
      OraclePipeRowStatement x = new OraclePipeRowStatement();
      x.setAfterSemi(this.afterSemi);
      x.setDbType(this.dbType);

      for(SQLExpr expr : this.parameters) {
         SQLExpr expr2 = expr.clone();
         expr2.setParent(x);
         x.parameters.add(expr2);
      }

      if (this.headHints != null) {
         List<SQLCommentHint> headHintsClone = new ArrayList(this.headHints.size());

         for(SQLCommentHint hint : this.headHints) {
            SQLCommentHint h2 = hint.clone();
            h2.setParent(x);
            headHintsClone.add(h2);
         }

         x.setHeadHints(headHintsClone);
      }

      return x;
   }
}
