package com.chenyang.druid.sql.dialect.oracle.ast.stmt;

import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.statement.SQLPrimaryKey;
import com.chenyang.druid.sql.ast.statement.SQLPrimaryKeyImpl;
import com.chenyang.druid.sql.ast.statement.SQLTableConstraint;
import com.chenyang.druid.sql.ast.statement.SQLTableElement;
import com.chenyang.druid.sql.dialect.oracle.visitor.OracleASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;

public class OraclePrimaryKey extends SQLPrimaryKeyImpl implements OracleConstraint, SQLPrimaryKey, SQLTableElement, SQLTableConstraint {
   private OracleUsingIndexClause using;
   private SQLName exceptionsInto;
   private Boolean enable;
   private Initially initially;
   private Boolean deferrable;

   protected void accept0(SQLASTVisitor visitor) {
      this.accept0((OracleASTVisitor)visitor);
   }

   public void accept0(OracleASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.getName());
         this.acceptChild(visitor, this.getColumns());
         this.acceptChild(visitor, this.using);
         this.acceptChild(visitor, this.exceptionsInto);
      }

      visitor.endVisit(this);
   }

   public Boolean getDeferrable() {
      return this.deferrable;
   }

   public void setDeferrable(Boolean deferrable) {
      this.deferrable = deferrable;
   }

   public OracleUsingIndexClause getUsing() {
      return this.using;
   }

   public void setUsing(OracleUsingIndexClause using) {
      this.using = using;
   }

   public SQLName getExceptionsInto() {
      return this.exceptionsInto;
   }

   public void setExceptionsInto(SQLName exceptionsInto) {
      this.exceptionsInto = exceptionsInto;
   }

   public Boolean getEnable() {
      return this.enable;
   }

   public void setEnable(Boolean enable) {
      this.enable = enable;
   }

   public Initially getInitially() {
      return this.initially;
   }

   public void setInitially(Initially initially) {
      this.initially = initially;
   }

   public void cloneTo(OraclePrimaryKey x) {
      super.cloneTo(x);
      if (this.using != null) {
         x.setUsing(this.using.clone());
      }

      if (this.exceptionsInto != null) {
         x.setExceptionsInto(this.exceptionsInto.clone());
      }

      x.enable = this.enable;
      x.initially = this.initially;
      x.deferrable = this.deferrable;
   }

   public OraclePrimaryKey clone() {
      OraclePrimaryKey x = new OraclePrimaryKey();
      this.cloneTo(x);
      return x;
   }
}
