package com.chenyang.druid.sql.dialect.oracle.ast.stmt;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.dialect.oracle.visitor.OracleASTVisitor;

public class OracleSetTransactionStatement extends OracleStatementImpl implements OracleStatement {
   private boolean readOnly = false;
   private boolean write = false;
   private SQLExpr name;

   public void accept0(OracleASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.name);
      }

      visitor.endVisit(this);
   }

   public SQLExpr getName() {
      return this.name;
   }

   public void setName(SQLExpr name) {
      this.name = name;
   }

   public boolean isReadOnly() {
      return this.readOnly;
   }

   public void setReadOnly(boolean readOnly) {
      this.readOnly = readOnly;
   }

   public boolean isWrite() {
      return this.write;
   }

   public void setWrite(boolean write) {
      this.write = write;
   }
}
