package com.chenyang.druid.sql.dialect.oracle.ast.stmt;

import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.SQLObject;
import com.chenyang.druid.sql.ast.SQLPartition;
import com.chenyang.druid.sql.ast.statement.SQLCreateIndexStatement;
import com.chenyang.druid.sql.dialect.oracle.ast.OracleSQLObject;
import com.chenyang.druid.sql.dialect.oracle.ast.OracleSegmentAttributesImpl;
import com.chenyang.druid.sql.dialect.oracle.visitor.OracleASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class OracleUsingIndexClause extends OracleSegmentAttributesImpl implements OracleSQLObject {
   private SQLObject index;
   private Boolean enable = null;
   private boolean computeStatistics = false;
   private boolean reverse;
   private List<SQLPartition> localPartitionIndex = new ArrayList();

   protected void accept0(SQLASTVisitor visitor) {
      this.accept0((OracleASTVisitor)visitor);
   }

   public void accept0(OracleASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.index);
         this.acceptChild(visitor, this.tablespace);
         this.acceptChild(visitor, this.storage);
      }

      visitor.endVisit(this);
   }

   public Boolean getEnable() {
      return this.enable;
   }

   public void setEnable(Boolean enable) {
      this.enable = enable;
   }

   public boolean isComputeStatistics() {
      return this.computeStatistics;
   }

   public void setComputeStatistics(boolean computeStatistics) {
      this.computeStatistics = computeStatistics;
   }

   public SQLObject getIndex() {
      return this.index;
   }

   public void setIndex(SQLName x) {
      if (x != null) {
         x.setParent(this);
      }

      this.index = x;
   }

   public void setIndex(SQLCreateIndexStatement x) {
      if (x != null) {
         x.setParent(this);
      }

      this.index = x;
   }

   public boolean isReverse() {
      return this.reverse;
   }

   public void setReverse(boolean reverse) {
      this.reverse = reverse;
   }

   public List<SQLPartition> getLocalPartitionIndex() {
      return this.localPartitionIndex;
   }

   public void cloneTo(OracleUsingIndexClause x) {
      super.cloneTo(x);
      if (this.index != null) {
         SQLObject idx = this.index.clone();
         idx.setParent(x);
         x.index = idx;
      }

      x.enable = this.enable;
      x.computeStatistics = this.computeStatistics;
      x.reverse = this.reverse;

      for(SQLPartition p : this.localPartitionIndex) {
         SQLPartition p2 = p.clone();
         p2.setParent(x);
         x.localPartitionIndex.add(p2);
      }

   }

   public OracleUsingIndexClause clone() {
      OracleUsingIndexClause x = new OracleUsingIndexClause();
      this.cloneTo(x);
      return x;
   }
}
