package com.chenyang.druid.sql.dialect.oracle.visitor;

import com.chenyang.druid.sql.ast.SQLOrderBy;
import com.chenyang.druid.sql.ast.expr.SQLBetweenExpr;
import com.chenyang.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.chenyang.druid.sql.ast.expr.SQLInListExpr;
import com.chenyang.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.chenyang.druid.sql.ast.statement.SQLSelectGroupByClause;
import com.chenyang.druid.sql.ast.statement.SQLSelectItem;
import com.chenyang.druid.sql.visitor.ExportParameterVisitor;
import com.chenyang.druid.sql.visitor.ExportParameterVisitorUtils;
import java.util.ArrayList;
import java.util.List;

public class OracleExportParameterVisitor extends OracleParameterizedOutputVisitor implements ExportParameterVisitor {
   private final boolean requireParameterizedOutput;

   public OracleExportParameterVisitor(List<Object> parameters, Appendable appender, boolean wantParameterizedOutput) {
      super(appender, false);
      this.parameters = parameters;
      this.requireParameterizedOutput = wantParameterizedOutput;
   }

   public OracleExportParameterVisitor() {
      this(new ArrayList());
   }

   public OracleExportParameterVisitor(List<Object> parameters) {
      this(parameters, new StringBuilder(), false);
   }

   public OracleExportParameterVisitor(Appendable appender) {
      this(new ArrayList(), appender, true);
   }

   public List<Object> getParameters() {
      return this.parameters;
   }

   public boolean visit(SQLSelectItem x) {
      return this.requireParameterizedOutput ? super.visit((SQLSelectItem)x) : false;
   }

   public boolean visit(SQLOrderBy x) {
      return this.requireParameterizedOutput ? super.visit((SQLOrderBy)x) : false;
   }

   public boolean visit(SQLSelectGroupByClause x) {
      return this.requireParameterizedOutput ? super.visit((SQLSelectGroupByClause)x) : false;
   }

   public boolean visit(SQLMethodInvokeExpr x) {
      if (this.requireParameterizedOutput) {
         return super.visit((SQLMethodInvokeExpr)x);
      } else {
         ExportParameterVisitorUtils.exportParamterAndAccept(this.parameters, x.getArguments());
         return true;
      }
   }

   public boolean visit(SQLInListExpr x) {
      if (this.requireParameterizedOutput) {
         return super.visit((SQLInListExpr)x);
      } else {
         ExportParameterVisitorUtils.exportParamterAndAccept(this.parameters, x.getTargetList());
         return true;
      }
   }

   public boolean visit(SQLBetweenExpr x) {
      if (this.requireParameterizedOutput) {
         return super.visit((SQLBetweenExpr)x);
      } else {
         ExportParameterVisitorUtils.exportParameter(this.parameters, x);
         return true;
      }
   }

   public boolean visit(SQLBinaryOpExpr x) {
      if (this.requireParameterizedOutput) {
         return super.visit(x);
      } else {
         ExportParameterVisitorUtils.exportParameter(this.parameters, x);
         return true;
      }
   }
}
