package com.chenyang.druid.sql.dialect.postgresql.ast.stmt;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.statement.SQLAlterDatabaseStatement;
import com.chenyang.druid.sql.ast.statement.SQLAlterStatement;
import com.chenyang.druid.sql.dialect.postgresql.visitor.PGASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;
import util.sqlparse.visitor.common.Objects;

public class PGAlterDatabaseStatement extends SQLAlterDatabaseStatement implements PGSQLStatement, SQLAlterStatement {
   private SQLName newName;
   private SQLExpr connLimit;
   private SQLExpr newOwner;
   private SQLExpr newTableSpace;
   private SQLExpr paramter;
   private boolean setFromCurrent;
   private boolean setTo;
   private SetType type;
   private List<SQLExpr> values;

   public PGAlterDatabaseStatement() {
      this.type = SetType.None;
      this.values = new ArrayList();
      this.dbType = DbType.postgresql;
   }

   public SQLName getNewName() {
      return this.newName;
   }

   public void setNewName(SQLName newName) {
      this.newName = newName;
      if (newName != null) {
         newName.setParent(this);
      }

   }

   public SQLExpr getConnLimit() {
      return this.connLimit;
   }

   public void setConnLimit(SQLExpr connLimit) {
      this.connLimit = connLimit;
      if (connLimit != null) {
         connLimit.setParent(this);
      }

   }

   public SQLExpr getNewOwner() {
      return this.newOwner;
   }

   public void setNewOwner(SQLExpr newOwner) {
      this.newOwner = newOwner;
      if (newOwner != null) {
         newOwner.setParent(this);
      }

   }

   public SQLExpr getNewTableSpace() {
      return this.newTableSpace;
   }

   public void setNewTableSpace(SQLExpr newTableSpace) {
      this.newTableSpace = newTableSpace;
      if (newTableSpace != null) {
         newTableSpace.setParent(this);
      }

   }

   public SQLExpr getParamter() {
      return this.paramter;
   }

   public void setParamter(SQLExpr paramter) {
      this.paramter = paramter;
      if (paramter != null) {
         paramter.setParent(this);
      }

   }

   public List<SQLExpr> getValues() {
      return this.values;
   }

   public void setValues(List<SQLExpr> values) {
      this.values = values;
   }

   public void addValue(SQLExpr value) {
      this.values.add(value);
      value.setParent(this);
   }

   public boolean isSetFromCurrent() {
      return this.setFromCurrent;
   }

   public void setSetFromCurrent(boolean setFromCurrent) {
      this.setFromCurrent = setFromCurrent;
   }

   public SetType getType() {
      return this.type;
   }

   public void setType(SetType type) {
      this.type = type;
   }

   public boolean isSetTo() {
      return this.setTo;
   }

   public void setSetTo(boolean setTo) {
      this.setTo = setTo;
   }

   public void accept0(SQLASTVisitor visitor) {
      this.accept0((PGASTVisitor)visitor);
   }

   public void accept0(PGASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.getName());
         this.acceptChild(visitor, this.newName);
         this.acceptChild(visitor, this.connLimit);
         this.acceptChild(visitor, this.newOwner);
         this.acceptChild(visitor, this.newTableSpace);
         this.acceptChild(visitor, this.paramter);
         this.acceptChild(visitor, this.values);
      }

      visitor.endVisit(this);
   }

   public PGAlterDatabaseStatement clone() {
      PGAlterDatabaseStatement c = new PGAlterDatabaseStatement();
      c.setName(this.getName().clone());
      if (this.newName != null) {
         c.newName = this.newName.clone();
      }

      if (this.connLimit != null) {
         c.connLimit = this.connLimit.clone();
      }

      if (this.newOwner != null) {
         c.newOwner = this.newOwner.clone();
      }

      if (this.newTableSpace != null) {
         c.newTableSpace = this.newTableSpace.clone();
      }

      if (this.paramter != null) {
         c.paramter = this.paramter.clone();
      }

      if (this.values != null) {
         for(SQLExpr value : this.values) {
            c.values.add(value.clone());
         }
      }

      c.setFromCurrent = this.setFromCurrent;
      c.type = this.type;
      c.setTo = this.setTo;
      return c;
   }

   public boolean equals(Object o) {
      if (this == o) {
         return true;
      } else if (o != null && this.getClass() == o.getClass()) {
         PGAlterDatabaseStatement that = (PGAlterDatabaseStatement)o;
         if (this.getName() == null && that.getName() != null) {
            return false;
         } else if (this.newName == null && that.newName != null) {
            return false;
         } else if (this.connLimit == null && that.connLimit != null) {
            return false;
         } else if (this.newOwner == null && that.newOwner != null) {
            return false;
         } else if (this.newTableSpace == null && that.newTableSpace != null) {
            return false;
         } else if (this.paramter == null && that.paramter != null) {
            return false;
         } else if (this.values.size() != that.values.size()) {
            return false;
         } else {
            for(int i = 0; i < this.values.size(); ++i) {
               if (!((SQLExpr)this.values.get(i)).equals(that.values.get(i))) {
                  return false;
               }
            }

            return this.setFromCurrent == that.setFromCurrent && Objects.equals(this.getName(), that.getName()) && Objects.equals(this.newName, that.newName) && Objects.equals(this.connLimit, that.connLimit) && Objects.equals(this.newOwner, that.newOwner) && Objects.equals(this.newTableSpace, that.newTableSpace) && Objects.equals(this.paramter, that.paramter) && this.type == that.type && this.setTo == that.setTo;
         }
      } else {
         return false;
      }
   }

   public int hashCode() {
      int prime = 31;
      int result = 31 * this.getName().hashCode();
      if (this.newName != null) {
         result = prime * 31 + this.newName.hashCode();
      }

      if (this.connLimit != null) {
         result = prime * 31 + this.connLimit.hashCode();
      }

      if (this.newOwner != null) {
         result = prime * 31 + this.newOwner.hashCode();
      }

      if (this.newTableSpace != null) {
         result = prime * 31 + this.newTableSpace.hashCode();
      }

      if (this.paramter != null) {
         result = prime * 31 + this.paramter.hashCode();
      }

      for(SQLExpr value : this.values) {
         result = prime * result + value.hashCode();
      }

      result = prime * 31 + (this.setFromCurrent ? 1 : 0);
      result = prime * 31 + (this.setTo ? 1 : 0);
      result = prime * 31 + this.type.hashCode();
      return result;
   }

   public static enum SetType {
      None,
      Reset,
      Set;
   }
}
