package com.chenyang.druid.sql.dialect.postgresql.ast.stmt;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.SQLStatementImpl;
import com.chenyang.druid.sql.dialect.postgresql.visitor.PGASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;

public class PGConnectToStatement extends SQLStatementImpl implements PGSQLStatement {
   private SQLName target;

   public PGConnectToStatement() {
      super(DbType.postgresql);
   }

   protected void accept0(SQLASTVisitor visitor) {
      this.accept0((PGASTVisitor)visitor);
   }

   public void accept0(PGASTVisitor v) {
      if (v.visit(this)) {
         this.acceptChild(v, this.target);
      }

      v.endVisit(this);
   }

   public SQLName getTarget() {
      return this.target;
   }

   public void setTarget(SQLName x) {
      if (x != null) {
         x.setParent(this);
      }

      this.target = x;
   }
}
