package com.chenyang.druid.sql.dialect.postgresql.ast.stmt;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.ast.statement.SQLSelect;
import com.chenyang.druid.sql.ast.statement.SQLSelectStatement;
import com.chenyang.druid.sql.dialect.postgresql.visitor.PGASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;

public class PGSelectStatement extends SQLSelectStatement implements PGSQLStatement {
   public PGSelectStatement() {
      super(DbType.postgresql);
   }

   public PGSelectStatement(SQLSelect select) {
      super(select, DbType.postgresql);
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor instanceof PGASTVisitor) {
         this.accept0((PGASTVisitor)visitor);
      } else {
         super.accept0(visitor);
      }

   }

   public void accept0(PGASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.select);
      }

      visitor.endVisit(this);
   }
}
